﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_SpeedEmulation.h>
#include <nn/fs/fs_ResultPrivate.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include "fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

Result SetSpeedEmulationMode(SpeedEmulationMode mode) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy
        = detail::GetFileSystemProxyServiceObject();

    nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator> deviceOperator;
    NN_FS_RESULT_DO(
        fileSystemProxy->OpenDeviceOperator(
            nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>>(&deviceOperator)));

    NN_FS_RESULT_DO(deviceOperator->SetSpeedEmulationMode(static_cast<int32_t>(mode)));
    NN_RESULT_SUCCESS;
}

Result GetSpeedEmulationMode(SpeedEmulationMode* pOutValue) NN_NOEXCEPT
{
    NN_FS_RESULT_THROW_UNLESS(pOutValue != nullptr, ResultNullptrArgument());

    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy
        = detail::GetFileSystemProxyServiceObject();

    nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator> deviceOperator;
    NN_FS_RESULT_DO(
        fileSystemProxy->OpenDeviceOperator(
            nn::sf::Out<nn::sf::SharedPointer<nn::fssrv::sf::IDeviceOperator>>(&deviceOperator)));

    int32_t mode = 0;
    NN_FS_RESULT_DO(deviceOperator->GetSpeedEmulationMode(nn::sf::Out<int32_t>(&mode)));
    *pOutValue = static_cast<SpeedEmulationMode>(mode);

    NN_RESULT_SUCCESS;
}

}}

