﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_Result.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>
#include "fs_FileSystemProxyServiceObject.h"

#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

bool IsSignedSystemPartitionOnSdCardValid() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    bool isValid = false;
    NN_FS_ABORT_UNLESS_RESULT_SUCCESS(fileSystemProxy->IsSignedSystemPartitionOnSdCardValid(&isValid));
    return isValid;
}

}}
