﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IEventNotifier.h>
#include <nn/fs/detail/fs_Newable.h>

namespace nn { namespace fs { namespace detail {

    class EventNotifierObjectAdapter : public nn::fs::IEventNotifier, public nn::fs::detail::Newable
    {
    public:
        NN_IMPLICIT EventNotifierObjectAdapter(nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier>&& eventNotifierObject) NN_NOEXCEPT;
        virtual ~EventNotifierObjectAdapter() NN_NOEXCEPT NN_OVERRIDE;

    private:
        nn::sf::SharedPointer<nn::fssrv::sf::IEventNotifier> m_EventNotifierObject;
        virtual Result DoBindEvent(nn::os::SystemEventType* systemEvent, nn::os::EventClearMode clearMode) NN_NOEXCEPT NN_OVERRIDE;
    };

}}}
