﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include "fs_FileSystemProxyServiceObject.h"

namespace nn { namespace fs {

using namespace nn::fs::detail;

Result CreatePaddingFile(int64_t paddingSize) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = GetFileSystemProxyServiceObject();
    NN_FS_RESULT_DO(fileSystemProxy->CreatePaddingFile(paddingSize));
    NN_RESULT_SUCCESS;
}

Result DeleteAllPaddingFiles() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = GetFileSystemProxyServiceObject();
    NN_FS_RESULT_DO(fileSystemProxy->DeleteAllPaddingFiles());
    NN_RESULT_SUCCESS;
}

Result OverrideSaveDataTransferTokenSignVerificationKey(const void* pBuffer, size_t bufferSize) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = GetFileSystemProxyServiceObject();
    NN_FS_RESULT_DO(fileSystemProxy->OverrideSaveDataTransferTokenSignVerificationKey(nn::sf::InBuffer(reinterpret_cast<const char*>(pBuffer), bufferSize)));
    NN_RESULT_SUCCESS;
}

Result SetDataStorageRedirectTarget(nn::ncm::StorageId storageId) NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::fssrv::sf::IFileSystemProxy> fileSystemProxy = detail::GetFileSystemProxyServiceObject();
    NN_RESULT_DO(fileSystemProxy->SetDataStorageRedirectTarget(storageId));
    NN_RESULT_SUCCESS;
}

}}
