﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "fs_UserMountTable.h"
#include "fs_MountTable.h"
#include "fs_FileSystemAccessor.h"

namespace nn { namespace fs { namespace detail {

namespace {
    MountTable s_MountTable;
}

Result Register(std::unique_ptr<FileSystemAccessor>&& fileSystem) NN_NOEXCEPT
{
    return s_MountTable.Mount(std::move(fileSystem));
}

Result Find(detail::FileSystemAccessor** outValue, const char* name) NN_NOEXCEPT
{
    return s_MountTable.Find(outValue, name);
}

void Unregister(const char* name) NN_NOEXCEPT
{
    s_MountTable.Unmount(name);
}

}}}
