﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_Directory.h>
#include <nn/fs/detail/fs_AccessLog.h>
#include "fs_DirectoryAccessor.h"
#include "fs_FileSystemAccessor.h"
#include <nn/fs/detail/fs_ResultHandlingUtility.h>

namespace nn { namespace fs {

namespace {
    detail::DirectoryAccessor& Get(DirectoryHandle handle) NN_NOEXCEPT
    {
        return *reinterpret_cast<detail::DirectoryAccessor*>(handle.handle);
    }
}

void CloseDirectory(DirectoryHandle handle) NN_NOEXCEPT
{
    NN_DETAIL_FS_ACCESS_LOG((delete &Get(handle), nn::ResultSuccess()), handle, "");
}

Result ReadDirectory(int64_t* outValue, DirectoryEntry* entryBuffer, DirectoryHandle handle, int64_t entryBufferCount) NN_NOEXCEPT
{
    NN_FS_RESULT_DO(NN_DETAIL_FS_ACCESS_LOG(Get(handle).Read(outValue, entryBuffer, entryBufferCount), handle, ""));
    NN_RESULT_SUCCESS;
}

Result GetDirectoryEntryCount(int64_t* outValue, DirectoryHandle handle) NN_NOEXCEPT
{
    NN_FS_RESULT_DO(Get(handle).GetEntryCount(outValue));
    NN_RESULT_SUCCESS;
}

}}
