﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Directory.h>
#include <nn/fs/detail/fs_Newable.h>
#include "fs_DirectoryAccessor.h"
#include "fs_IntrusiveList.h"

namespace nn { namespace fs {

    namespace fsa {
        class IDirectory;
    }

namespace detail{

    class FileSystemAccessor;

    class DirectoryAccessor : public Newable
    {
        NN_DISALLOW_COPY(DirectoryAccessor);

    public:
        DirectoryAccessor(std::unique_ptr<fsa::IDirectory>&& directory, FileSystemAccessor& parent) NN_NOEXCEPT;
        ~DirectoryAccessor() NN_NOEXCEPT;

        Result Read(int64_t* outValue, DirectoryEntry* outEntries, int64_t count) NN_NOEXCEPT;
        Result GetEntryCount(int64_t* outValue) NN_NOEXCEPT;
        FileSystemAccessor& GetParent() NN_NOEXCEPT
        {
            return m_Parent;
        }

        IntrusiveListNode m_ListNode;

    private:
        std::unique_ptr<fsa::IDirectory> m_Impl;
        FileSystemAccessor& m_Parent;
    };

}}}
