﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Result.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/eth/sfdl/eth.sfdl.h>

namespace nn     {
namespace eth    {
namespace server {

class Interface;

class InterfaceSfObject :
    public nn::sf::ISharedObject,
    public nn::util::IntrusiveListBaseNode<InterfaceSfObject>
{
private:
    nn::Result          m_Result;
    nn::os::SystemEvent m_SystemEvent;
    nn::os::Mutex       m_Lock;
    Interface*          m_pInterface;

public:
    nn::Result GetMediaList(const nn::sf::OutBuffer& mediaOut) NN_NOEXCEPT;
    nn::Result SetMediaType(MediaType mediaTypeIn) NN_NOEXCEPT;
    nn::Result GetMediaType(nn::sf::Out<MediaType> mediaRequested, nn::sf::Out<MediaType> mediaCurrent, nn::sf::Out<unsigned int> eventCounter) NN_NOEXCEPT;
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetResult() NN_NOEXCEPT;
    void       Detach() NN_NOEXCEPT;
    void       Signal(nn::Result result) NN_NOEXCEPT;
    nn::Result Initialize(nn::sf::Out<nn::sf::NativeHandle> handleOut, const nn::sf::InBuffer& interfaceName) NN_NOEXCEPT;
    InterfaceSfObject() NN_NOEXCEPT;
    ~InterfaceSfObject() NN_NOEXCEPT;
};

}}}
