﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>

#include "eth_DeviceMain.h"
#include "usb/eth_UsbMain.h"
#include "tx2/eth_Tx2Main.h"

namespace nn     {
namespace eth    {
namespace device {

uint32_t GetInterfaceCount() NN_NOEXCEPT
{
    int count = 0;

    // USB driver has not implemented on TX2 yet.
    //count += nn::eth::device::usb::GetInterfaceCount();

    count += nn::eth::device::tx2::GetInterfaceCount();

    return count;
}

nn::Result Initialize() NN_NOEXCEPT
{
    // USB driver has not implemented on TX2 yet.
    //NN_RESULT_DO(nn::eth::device::usb::Initialize());

    NN_RESULT_DO(nn::eth::device::tx2::Initialize());

    return nn::ResultSuccess();
}

}}}
