﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/dt/dt_Result.h>
#include <nn/dt/dt_ResultPrivate.h>
#include "dt_FdtReaderUtil.h"

namespace nn { namespace dt { namespace server {

nn::Result GetInterruptInfo(InterruptInfo* pOutInfo, const uint32_t* pCells, size_t cellCount)
{
    NN_UNUSED(pOutInfo);
    NN_UNUSED(pCells);
    NN_UNUSED(cellCount);

    // 未実装の場合は nn::dt::ResultApiNotSupported() を返す。
    // また、Windows だと nn::os::InterruptName が const char* になるため、
    // まともに InterruptInfo.name をセットする機能は作れないことに注意する。
    return nn::dt::ResultApiNotSupported();
}

}}}
