﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/dt/dt_Types.h>
#include <nn/dt/detail/dt_IDeviceTree.h>

namespace nn { namespace dt { namespace server {

class DeviceTreeInterface
{
public:
    nn::Result FindNodeByPath(nn::sf::Out<nn::dt::Node> outNode, const nn::sf::InBuffer& path) NN_NOEXCEPT;
    nn::Result FindNodeByPHandle(nn::sf::Out<nn::dt::Node> outNode, std::uint32_t phandle) NN_NOEXCEPT;
    nn::Result GetCompatibleNodeCount(nn::sf::Out<std::uint64_t> outCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
    nn::Result ListCompatibleNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, const nn::sf::InBuffer& compatible) NN_NOEXCEPT;
    nn::Result GetParentNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetChildNodeByName(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetChildNodeCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result ListChildNode(const nn::sf::OutBuffer& outNodeList, nn::sf::Out<std::uint64_t> outCount, std::uint64_t maxCount, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetValueOfAddressCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetValueOfSizeCells(nn::sf::Out<std::uint32_t> outValue, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result IsPropertyExist(nn::sf::Out<bool> outExist, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetPropertySize(nn::sf::Out<std::uint64_t> outSize, nn::dt::Node node, const nn::sf::InBuffer& name) NN_NOEXCEPT;
    nn::Result GetProperty(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetPropertyWithIndex(const nn::sf::OutBuffer& outValue, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t index, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetPropertyList(const nn::sf::OutBuffer& outArray, nn::sf::Out<std::uint64_t> outPropertySize, std::uint64_t maxCount, nn::dt::Node node, const nn::sf::InBuffer& name, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetInterruptCount(nn::sf::Out<std::uint64_t> outCount, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetInterruptList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result GetRegisterAddressList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetRegisterSizeList(const nn::sf::OutBuffer& outList, nn::sf::Out<std::uint64_t> outActualCount, std::uint64_t maxCount, nn::dt::Node node, std::uint64_t elementSize) NN_NOEXCEPT;
    nn::Result GetFirstChildNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetNextSiblingNode(nn::sf::Out<nn::dt::Node> outNode, nn::dt::Node currentNode) NN_NOEXCEPT;
    nn::Result GetNodePath(const nn::sf::OutBuffer& outPath, nn::dt::Node node) NN_NOEXCEPT;
    nn::Result DumpNode(nn::dt::Node node, std::int32_t depth) NN_NOEXCEPT;
};

}}}
