﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/diag/detail/diag_DetailLog.h>
#include <nn/diag/diag_LogObserver.h>
#include "diag_LogImpl.h"
#include <nn/cstd/cstd_CStdArg.h>
#include <cstdio>
#include <cstdarg>

#include <nn/nn_Abort.h>
#include <nn/nn_StaticAssert.h>
#include <nnc/nn_Abort.h>
#include <nnc/nn_Assert.h>

// macro.h に記述されている NN_UNEXPECTED_DEFAULT の実装の C言語版です。
// C++ 版と同様 diag ライブラリに含めておきます。
extern "C" void nndetailUnexpectedDefaultImpl(
    const char* functionName,
    const char* fileName,
    int lineNumber) NN_NOEXCEPT
{
    nn::diag::detail::AbortImpl(
        "unexpected value passed to switch statement", functionName, fileName, lineNumber, "");
}

extern "C" NN_NORETURN void nndetailDiagAbortFormatImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...) NN_NOEXCEPT
{
    std::va_list list;
    va_start(list, format);

    nn::diag::detail::AbortImpl(condition, functionName, fileName, lineNumber, format, list);

    // ここには制御が返らない
    //va_end(list);
}

extern "C" NN_NORETURN void nndetailDiagAbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber) NN_NOEXCEPT
{
    nn::diag::detail::AbortImpl(condition, functionName, fileName, lineNumber, "");
}

extern "C" void nndetailDiagOnAssertionFailureFormat( // NOLINT(function/noexcept)
    nndiagAssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...)
{
    std::va_list list;
    va_start(list, format);

    NN_STATIC_ASSERT(static_cast<nn::diag::AssertionType>(nndiagAssertionType_SdkAssert) == nn::diag::AssertionType_SdkAssert);
    NN_STATIC_ASSERT(static_cast<nn::diag::AssertionType>(nndiagAssertionType_SdkRequires) == nn::diag::AssertionType_SdkRequires);
    NN_STATIC_ASSERT(static_cast<nn::diag::AssertionType>(nndiagAssertionType_UserAssert) == nn::diag::AssertionType_UserAssert);

    nn::diag::detail::OnAssertionFailure(static_cast<nn::diag::AssertionType>(assertionType), condition, functionName, fileName, lineNumber, format, list);

    // ここには制御が返らない
    //va_end(list);
}

extern "C" void nndetailDiagOnAssertionFailure( // NOLINT(function/noexcept)
    nndiagAssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber)
{
    nn::diag::detail::OnAssertionFailure(static_cast<nn::diag::AssertionType>(assertionType), condition, functionName, fileName, lineNumber, "");
}
