﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/util/util_Utf8StringUtil.h>

extern "C" void nnMain();

namespace nn { namespace diag { namespace detail {

uintptr_t GetModuleInfoForHorizon(const char** pOutPath, size_t* pOutLength, size_t* outModuleSize, uintptr_t address) NN_NOEXCEPT;

namespace {
    const char* GetLastCharacterPointer(const char* string, size_t length, char character) NN_NOEXCEPT
    {
        for (auto pLast = string + length - 1; pLast >= string; pLast--)
        {
            if (*pLast == character)
            {
                return pLast;
            }
        }
        return nullptr;
    }

    void GetFileNameWithoutExtension(const char** out, size_t* outLength, const char* path, size_t pathLength) NN_NOEXCEPT
    {
        const auto pLastSeparator = GetLastCharacterPointer(path, pathLength, '\\');
        const auto pExtension = GetLastCharacterPointer(path, pathLength, '.');

        *out = pLastSeparator
            ? pLastSeparator + 1
            : path;

        *outLength = pExtension && pExtension >= *out
            ? pExtension - *out
            : (path + pathLength) - *out;
    }

    struct ProcessName
    {
        ProcessName() NN_NOEXCEPT
        {
            const char* path;
            size_t pathLength;
            size_t moduleSize;
            // main モジュールのモジュール名をプロセス名として利用する。
            if (GetModuleInfoForHorizon(&path, &pathLength, &moduleSize, reinterpret_cast<uintptr_t>(nnMain)) != 0)
            {
                GetFileNameWithoutExtension(&data, &length, path, pathLength);
                NN_SDK_ASSERT(length == 0 || util::VerifyUtf8String(data, length));
            }
            else
            {
                data = "";
                length = 0;
            }
        }
        const char* data;
        size_t length;
    };
}

void GetProcessNamePointer(const char** out, size_t* outLength) NN_NOEXCEPT
{
    NN_FUNCTION_LOCAL_STATIC(ProcessName, s_Cache);
    *out = s_Cache.data;
    *outLength = s_Cache.length;
}

}}} // nn::diag::detail
