﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Windows.h>

#include <nn/nn_Macro.h>

namespace nn { namespace dd {
namespace detail {

inline void InitializePhysicalMemoryInfoImpl( PhysicalMemoryInfo* pOutInfo, const void* addr, size_t size ) NN_NOEXCEPT
{
    NN_UNUSED(pOutInfo);
    NN_UNUSED(addr);
    NN_UNUSED(size);
}

inline Result QueryNextPhysicalMemoryInfoImpl( PhysicalMemoryInfo* pOutInfo ) NN_NOEXCEPT
{
    NN_UNUSED(pOutInfo);
    return ResultEndOfQuery();
}

inline Result QuerySinglePhysicalAddressImpl( PhysicalAddress* pOutAddress, const void* addr, size_t size ) NN_NOEXCEPT
{
    NN_UNUSED(pOutAddress);
    NN_UNUSED(addr);
    NN_UNUSED(size);
    return nn::ResultSuccess();
}

}   // namespace detail
}}  // namespace nn::dd
