﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Macros
 *
 * @details
 */

#pragma once


namespace nn { namespace bsdsocket { namespace cfg {

// Log macros
#define CFG_ABORT(format,...)            NN_ABORT(format, ##__VA_ARGS__)
#define CFG_ABORT_UNLESS_SUCCESS(result) NN_ABORT_UNLESS((result).IsSuccess())
#define CFG_ABORT_NULL(pointerVal)       NN_ABORT_UNLESS_NOT_NULL(pointerVal)
#define CFG_LOG_VERBOSE(format,...)      //NN_SDK_LOG("[CFG] verbose: " format, ##__VA_ARGS__)
#define CFG_LOG_INFO(format,...)         NN_SDK_LOG("[CFG] info: " format, ##__VA_ARGS__)
#define CFG_LOG_WARN(format,...)         NN_SDK_LOG("[CFG] warning: " format, ##__VA_ARGS__)
#define CFG_LOG_ERROR(format,...)        NN_SDK_LOG("[CFG] error: " format, ##__VA_ARGS__)
#define CFG_LOG_NOPREFIX(format,...)     NN_SDK_LOG(format, ##__VA_ARGS__)

// Error handling macros
#define CFG_BREAK_UPON_ERROR(attemptedMethodCall)                                    \
    if (!((result=(attemptedMethodCall)).IsSuccess()))                               \
    {                                                                                \
        CFG_LOG_WARN("file-%s, line-%d, call to %s failed, handled with break.\n",   \
                     __FILE__,__LINE__,#attemptedMethodCall);  break;                \
    }

#define CFG_RETURN_UPON_ERROR(attemptedMethodCall)                                   \
    if (!((result=(attemptedMethodCall)).IsSuccess()))                               \
    {                                                                                \
        CFG_LOG_WARN("file-%s, line-%d, call to %s failed, handled with return.\n",  \
                     __FILE__,__LINE__,#attemptedMethodCall);  return result;        \
    }

#define CFG_COMPARE_RESULT(a, b)  \
    ((((a).GetInnerValueForDebug()) == ((b).GetInnerValueForDebug())) ? true : false)

} // namespace cfg
} // namespace bsdsocket
} // namespace nn


