﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include "../kern_Platform.h"
#include "kern_SvcHandlers.h"
#include "kern_SvcValueCheck.h"
#include "../kern_DebugString.h"
#include "../kern_KTrace.h"
#include "../kern_Trace.h"
#include "kern_SystemControl.h"

namespace nn { namespace kern { namespace svc {
namespace {

void SvcChangeKernelTraceState(nn::svc::KernelTraceState state)
{
    NN_UNUSED(state);
    if (!KTargetSystem::IsDevelopmentHardware())
    {
        return;
    }
    if (!KTargetSystem::IsInternalDebugEnabled())
    {
        return;
    }
#if defined NN_KERN_FOR_DEVELOPMENT
    switch (state)
    {
    case nn::svc::KernelTraceState_Paused:
        {
            NN_KERN_KTRACE_STOP();
            NN_KERN_TRACE_STOP();
        }
        break;
    case nn::svc::KernelTraceState_Running:
        {
            NN_KERN_KTRACE_START();
            NN_KERN_TRACE_START();
        }
        break;
    default:
        break;
    }
#endif
}

}

#if defined(NN_BUILD_CONFIG_CPU_SVC_32)
void SvcChangeKernelTraceState32(nn::svc::KernelTraceState state)
{
    SvcChangeKernelTraceState(state);
    ClearSvcOutRegisters();
}
#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64)
void SvcChangeKernelTraceState64(nn::svc::KernelTraceState state)
{
    SvcChangeKernelTraceState(state);
    ClearSvcOutRegisters();
}
#endif

#if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
void SvcChangeKernelTraceState64From32(nn::svc::KernelTraceState state)
{
    SvcChangeKernelTraceState(state);
    ClearSvcOutRegisters();
}
#endif // #if defined(NN_BUILD_CONFIG_CPU_SVC_64FROM32)
}}}
