﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include "kern_Platform.h"
#include "kern_New.h"
#include "kern_Panic.h"
#undef NN_KERNEL_PANIC
#define NN_KERNEL_PANIC(...)
#if 0
#include <new>

using namespace nn::kern;

void* operator new (size_t size) throw(std::bad_alloc)
{
    NN_UNUSED(size);
    NN_KERNEL_PANIC("operator new(size_t) called\n");
//    extern void* undefined_symbol_for_new_linking_error;
//    return undefined_symbol_for_new_linking_error;
    return NULL;
}

//void* operator new[] (size_t size) throw()
//{
//    return (void*) Kernel::GetMemoryManager().AllocateContinuous(size / NN_KERN_FINEST_PAGE_SIZE + 1);
//}

void* operator new (size_t size, const ::std::nothrow_t&) throw()
{
    NN_UNUSED(size);
    NN_KERNEL_PANIC("operator new(size_t, const ::std::nothrow_t&) called\n");
//    extern void* undefined_symbol_for_new_linking_error;
//    return undefined_symbol_for_new_linking_error;
    return NULL;
}
#endif

//void* operator new[] (size_t size, const ::std::nothrow_t) throw()
//{
//    return (void*) Kernel::GetMemoryManager().AllocateContinuous(size / NN_KERN_FINEST_PAGE_SIZE + 1);
//}

void  operator delete (void* pDeadObj) throw()
{
    NN_UNUSED(pDeadObj);
    NN_KERNEL_PANIC("operator delete(void*) called\n");
//    extern void* undefined_symbol_for_new_linking_error;
//    undefined_symbol_for_new_linking_error = pDeadObj;
}

//void  operator delete[] (void* pDeadObj) throw()
//{
//    Kernel::GetMemoryManager().Free((uintptr_t)pDeadObj, 1);
//}

//void operator delete (void* pDeadObj, const ::std::nothrow_t&) throw()
//{
//    Kernel::GetMemoryManager().Free((uintptr_t)pDeadObj, 1);
//}

//void operator delete[] (void* pDeadObj, const ::std::nothrow_t&) throw()
//{
//    Kernel::GetMemoryManager().Free((uintptr_t)pDeadObj, 1);
//}

void* operator new (size_t size, void* p) throw()
{
    NN_UNUSED(size);
    return p;
}

//void* operator new[] (size_t size, void* p)
//{
//    return p;
//}

//void  operator delete (void* pDeadObj, void* )
//{
//}

//void  operator delete[] (void* pDeadObj, void* )
//{
//}

