﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_KSpinLockMutex.h"
#include "kern_KScheduler.h"


namespace nn { namespace kern {

/*!
    @brief     スコープを持つ プリエンプション禁止クラスの定義です。

    ロック中は、以下のようになります。

      ・スレッドのスケジューリングが停止します。(SpinLockMutexがプリエンプションロックします)
        つまり同一コア内の他のスレッドが SchedulerMutex の Lock 内に入る事はありません。

      ・他の CPU が SchedulerMutex の Lock 内に入る事はありません。

      ・ハードウェア割り込み処理はそのまま発生します。
        スコープ内を割り込み処理からは保護できません。

     従いまして、割り込みを含めた排他制御を行う場合は、プリエンプションロックに加えて
     明示的に "KDisableInterrupt" スコープロックオブジェクトを生成し、
     割り込みを禁止する必要があります。

*/
class KScopedSchedulingLock
{
public:
    //! コンストラクタ
    KScopedSchedulingLock() { KScheduler::s_SchedulerMutex.Lock(); }
    //! デストラクタ
    ~KScopedSchedulingLock() { KScheduler::s_SchedulerMutex.UnlockAndScheduleAll(); }
};

}}

