﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_KObjectAdaptor.h"
#include "kern_KAutoObject.h"
#include "kern_KServerPort.h"
#include "kern_KClientPort.h"

namespace nn { namespace kern {

class KServerSession;
class KLightServerSession;

class KPort :
    public KObjectAdaptor<KPort, KAutoObjectWithList>

{
private:
    enum State: uint8_t
    {
        STATE_INVALID,                              //!< 無効な状態(未初期化)
        STATE_ACTIVE,                               //!< ポートが有効
        STATE_CLIENT_CLOSED,                        //!< クライアントポートが閉じられました
        STATE_SERVER_CLOSED                         //!< サーバーポートが閉じられました
    };

    KServerPort     m_Server;
    KClientPort     m_Client;
    uintptr_t       m_Name;
    State           m_State;
    bool            m_IsLight;

public:
    explicit         KPort();
    virtual          ~KPort();

    void            Initialize(int32_t maxSessions, bool isLight, uintptr_t name);
    void            OnServerClosed();
    void            OnClientClosed();
    KServerPort&    GetServerPort() { return m_Server; }
    KClientPort&    GetClientPort() { return m_Client; }
    const KServerPort& GetServerPort() const { return m_Server; }
    const KClientPort& GetClientPort() const { return m_Client; }
    bool            IsLight() const { return m_IsLight; }
    uintptr_t       GetName() const { return m_Name; }
    Result          EnqueueSession(KServerSession* pSession);
    Result          EnqueueSession(KLightServerSession* pSession);
    static void     PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KPort, KAutoObject)
};

}}

