﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*!
    @file

    @brief 割り込みタスクに関する API の宣言

*/

#pragma once

#include <nn/nn_Common.h>
#include "kern_KInterruptHandler.h"

namespace nn { namespace kern {

/*!
    @brief     割り込みタスククラスの定義です。

    割り込みタスクは次のタスクへのポインタを保持するリンクリスト構造になっています。

*/
class KInterruptTask
    : public KInterruptHandler
{
public:
    KInterruptTask() : m_pNextTask(NULL) {}

    /*!
        @brief     次のタスクを設定します。

                   KInterruptTaskManagerから呼び出されます
    */
    void            SetNextTask(KInterruptTask* pTask)  { m_pNextTask = pTask; }

    /*!
        @brief     次のタスクを取得します。

                   KInterruptTaskManagerから呼び出されます
    */
    KInterruptTask* GetNextTask()                       { return m_pNextTask; }

public:
    /*!
        @brief  DPC スレッド中での処理です。

                割り込み許可状態で呼ばれる高優先度のスレッドです。
                データの処理、同期オブジェクトのシグナル化など、
                KInterruptEvent::OnInterrupt の処理の続きをこちらで記述します。

    */
    // override KInterruptTask
    virtual void DoInterruptTask() = 0;

private:
    //! 次のタスクへのポインタ(リンクリスト)
    KInterruptTask* m_pNextTask;
};

}}

