﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_Platform.h"
#include "kern_Assert.h"
#include "kern_Kernel.h"
#include "kern_KEvent.h"
#include "kern_KReadableEvent.h"
#include "kern_KWritableEvent.h"
#include "kern_KScopedSchedulingLock.h"
#include "kern_KProcess.h"

namespace nn { namespace kern {

NN_AUTOOBJECT_DEFINE_TYPE_NAME(KEvent);

void KEvent::Initialize()
{
    NN_KERN_THIS_ASSERT();

    Open();

    KAutoObject::Create(&m_ReadableEvent);
    KAutoObject::Create(&m_WritableEvent);

    m_ReadableEvent.Initialize(this);
    m_WritableEvent.Initialize(this);
    m_pOwner = GetCurrentProcessPointer();
    m_pOwner->Open();
    m_IsInitialized = true;
}

void KEvent::Finalize()
{
    NN_KERN_THIS_ASSERT();

    KObjectAdaptor<KEvent, KAutoObjectWithList>::Finalize();
}

void KEvent::PostFinalize(uintptr_t arg)
{
    KProcess* pOwner = reinterpret_cast<KProcess*>(arg);
    pOwner->ReleaseLimit(nn::svc::LimitableResource_EventCountMax, 1);
    pOwner->Close();
}


}}
