﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_PageTableSelect.h"
#include "kern_DevicePageTableSelect.h"
#include "kern_KPageGroup.h"
#include "kern_KObjectAdaptor.h"
#include "kern_KLightMutex.h"

namespace nn { namespace kern {

class KDeviceAddressSpace : public KObjectAdaptor<KDeviceAddressSpace, KAutoObjectWithList>
{
private:
    KLightMutex      m_Lock;
    KDevicePageTable m_Table;
    uint64_t         m_SpaceAddress;
    uint64_t         m_SpaceSize;
    bool             m_IsInitialized;
public:
    explicit KDeviceAddressSpace();
    virtual ~KDeviceAddressSpace();

    virtual void Finalize();

    virtual bool IsInitialized() const { return m_IsInitialized; }
    static void PostFinalize(uintptr_t arg) { NN_UNUSED(arg); }

    Result  Initialize(uint64_t spaceAddress, uint64_t spaceSize);

    Result  Attach(nn::svc::DeviceName deviceName);
    Result  Detach(nn::svc::DeviceName deviceName);

    Result Map(size_t* pMapSize, KProcessPageTable* pPageTable,
            KProcessAddress processAddress, size_t size,
            uint64_t deviceAddress,
            nn::svc::MemoryPermission devicePermission,
            bool breakAllocate)
    {
        return Map(pMapSize, pPageTable, processAddress, size, deviceAddress, devicePermission, false, breakAllocate);
    }

    Result MapAligned(KProcessPageTable* pPageTable,
            KProcessAddress processAddress, size_t size,
            uint64_t deviceAddress,
            nn::svc::MemoryPermission devicePermission)
    {
        size_t mapSize;
        return Map(&mapSize, pPageTable, processAddress, size, deviceAddress, devicePermission, true, false);
    }

    Result Unmap(KProcessPageTable* pPageTable,
            KProcessAddress processAddress, size_t size,
            uint64_t deviceAddress);

    static void Initialize();

private:
    Result Map(size_t* pMapSize, KProcessPageTable* pPageTable,
            KProcessAddress processAddress, size_t size,
            uint64_t deviceAddress,
            nn::svc::MemoryPermission devicePermission,
            bool isAligned, bool breakAllocate);

    //! KAutoObjectのプリセット関数セット定義です。クラスの末尾に記述する必要があります
    NN_AUTOOBJECT_DERIVED_FUNCSET(KDeviceAddressSpace, KAutoObject)
};

}}

