﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "kern_KSynchronizationObject.h"

namespace nn { namespace kern {

class KThread;
class KPort;
class KSession;
class KClientSession;
class KLightSession;
class KLightClientSession;

class KClientPort : public KSynchronizationObject
{
private:
    InterlockedVariable<int32_t>   m_NumSessions;
    InterlockedVariable<int32_t>   m_PeakSessions;
    int32_t                        m_MaxSessions;
    KPort*                         m_pParent;

public:
    explicit        KClientPort() {}
    virtual         ~KClientPort() {}
    virtual void    Destroy();
    virtual bool    IsSignaled() const;

    void            Initialize(KPort* p, int32_t maxSessions);
    void            OnSessionFinalized();
    void            OnServerClosed();
    int32_t         GetMaxSessions()  const { return m_MaxSessions; }
    int32_t         GetPeakSessions() const { return m_PeakSessions; }
    int32_t         GetNumSessions()  const { return m_NumSessions; }

    Result  CreateSession(KClientSession** pSession);
    Result  CreateLightSession(KLightClientSession** pSession);
    bool            IsLight() const;

    const KPort*    GetParent() const { return m_pParent; }

    NN_AUTOOBJECT_DERIVED_FUNCSET(KClientPort, KSynchronizationObject)
};


}}

