﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_BitTypes.h>

#if   defined(NN_BUILD_CONFIG_CPU_ARM_V7A)

    #include "ip/ARMv7A/kern_KInterruptManager.h"
    namespace nn { namespace kern {
        using nn::kern::ARMv7A::KInterruptManager;
    }}

#elif   defined(NN_BUILD_CONFIG_CPU_ARM_V8A)

    #include "ip/ARMv8A/kern_KInterruptManager.h"
    namespace nn { namespace kern {
        using nn::kern::ARMv8A::KInterruptManager;
    }}

#elif   defined(NN_BUILD_CONFIG_CPU_PPC32)

    #include "PPC32/kern_KInterruptManager.h"
    namespace nn { namespace kern {
        using nn::kern::PPC32::KInterruptManager;
    }}

#else
#error no KInterruptManager is selected
#endif

namespace nn { namespace kern {

/*!
    @brief CPUの割り込みを禁止をするためのクラスです。

           このオブジェクトが生存している期間に限り、現在実行中のコアの割り込みを禁止します。
           メニーコア環境では割り込みを禁止しても、他のコアからアクセスされうる可能性がある
           ことに留意してください。

*/

class KDisableInterrupt
{
private:
    //! 直前の割り込み許可状態を保存します。
    Bit32 m_PrevState;

public:
    KDisableInterrupt()
    {
        m_PrevState = KInterruptManager::DisableInterrupt();
    }
    ~KDisableInterrupt()
    {
        KInterruptManager::RestoreInterrupt(m_PrevState);
    }
};

class KEnableInterrupt
{
private:
    //! 直前の割り込み許可状態を保存します。
    Bit32 m_PrevState;

public:
    KEnableInterrupt()
    {
        m_PrevState = KInterruptManager::EnableInterrupt();
    }
    ~KEnableInterrupt()
    {
        KInterruptManager::RestoreInterrupt(m_PrevState);
    }
};

}}

