﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>
#include "kern_MemoryMap.h"
#include "../../kern_KTaggedAddress.h"
#include "kern_KPageTable.h"

namespace nn { namespace kern { namespace ARMv7A {

class KKernelPageTable
{
public:
    void Initialize(int32_t coreNo);
    void Finalize(int32_t coreNo);

    bool GetPhysicalAddress(KPhysicalAddress* pOut, KProcessAddress addr) const
        { return m_Table.GetPhysicalAddress(pOut, addr); }

    KVirtualAddress GetHeapVirtualAddress(KPhysicalAddress pa) const
        { return m_Table.GetHeapVirtualAddress(pa); }

    Result  MapPages(
                KProcessAddress*    pAddr,
                size_t              numPages,
                size_t              align,
                KPhysicalAddress    physAddr,
                KProcessAddress     regionBegin,
                size_t              regionNumPages,
                KMemoryState        state,
                KMemoryPermission   permission)
    {
        return m_Table.MapPages(pAddr, numPages, align, physAddr, regionBegin, regionNumPages, state, permission);
    }

    Result  UnmapPages(
            KProcessAddress     addr,
            size_t              numPages,
            KMemoryState        state)
    {
        return m_Table.UnmapPages(addr, numPages, state);
    }

    Result MapPageGroup(
            KProcessAddress*    pAddr,
            const KPageGroup&   pg,
            KProcessAddress     regionBegin,
            size_t              regionNumPages,
            KMemoryState        state,
            KMemoryPermission   permission)
    {
        return m_Table.MapPageGroup(pAddr, pg, regionBegin, regionNumPages, state, permission);
    }

    Result UnmapPageGroup(KProcessAddress addr, const KPageGroup& pg, KMemoryState state)
    {
        return m_Table.UnmapPageGroup(addr, pg, state);
    }

    void Activate()   { KPageTable::Activate(&m_Table); }

    void Dump() const { return m_Table.DumpMemoryBlocks(); }
    void DumpPageTable() const { return m_Table.DumpPageTable(); }
    size_t CountPageTables() const { return m_Table.CountPageTables(); }
private:
    KPageTable  m_Table;
};

}}} // namespace

