﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../kern_Assembly.h"

ENTRY(_ZN2nn4kern3svc22SvcCallSecureMonitor64Ev)
    sub     sp, sp, #(4 * 16)
    stp     x0, x1,   [sp, #(0 * 16)]
    stp     x2, x3,   [sp, #(1 * 16)]
    stp     x4, x5,   [sp, #(2 * 16)]
    stp     x6, x7,   [sp, #(3 * 16)]

    mov     x0, sp
    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc22SvcCallSecureMonitor64EPm
    ldp     x29, x30, [sp], #16

    ldp     x0, x1,   [sp, #(0 * 16)]
    ldp     x2, x3,   [sp, #(1 * 16)]
    ldp     x4, x5,   [sp, #(2 * 16)]
    ldp     x6, x7,   [sp, #(3 * 16)]
    add     sp, sp, #(4 * 16)
    ret
SET_SIZE(_ZN2nn4kern3svc22SvcCallSecureMonitor64Ev)

//
//    |
//    +------------
//    |   X7
//    +------------
//    |   X6
//    +------------
//    |   X5
//    +------------
//    |   X4
// SP +------------
//    |
ENTRY(_ZN2nn4kern3svc28SvcCallSecureMonitor64From32Ev)
    sub     sp, sp, #(2 * 16)
    stp     x0, x1,   [sp, #(0 * 16)]
    stp     x2, x3,   [sp, #(1 * 16)]

    mov     x0, sp
    stp     x29, x30, [sp, #-16]!
    bl      _ZN2nn4kern3svc22SvcCallSecureMonitor64EPm
    ldp     x29, x30, [sp], #16

    ldp     x0, x1,   [sp, #(0 * 16)]
    ldp     x2, x3,   [sp, #(1 * 16)]
    add     sp, sp, #(2 * 16)
    ret
SET_SIZE(_ZN2nn4kern3svc28SvcCallSecureMonitor64From32Ev)
