﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Base.h>

//----------------------------------------------------------------------
//                  Program Status Register
//----------------------------------------------------------------------

#ifndef NN_KERN_UL
#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ull
#endif
#endif

#define HW_PSR_CPU_MODE_MASK        NN_KERN_UL(0x1f)    // CPU mode

// AArch64)
#define HW_PSR_EL0T_MODE            NN_KERN_UL(0x00)
#define HW_PSR_EL1T_MODE            NN_KERN_UL(0x04)
#define HW_PSR_EL1H_MODE            NN_KERN_UL(0x05)
#define HW_PSR_EL2T_MODE            NN_KERN_UL(0x08)
#define HW_PSR_EL2H_MODE            NN_KERN_UL(0x09)
#define HW_PSR_EL3T_MODE            NN_KERN_UL(0x0c)
#define HW_PSR_EL3H_MODE            NN_KERN_UL(0x0d)

// AArch32
#define HW_PSR_USR_MODE             NN_KERN_UL(0x10)  // User mode
#define HW_PSR_FIQ_MODE             NN_KERN_UL(0x11)  // FIQ mode
#define HW_PSR_IRQ_MODE             NN_KERN_UL(0x12)  // IRQ mode
#define HW_PSR_SVC_MODE             NN_KERN_UL(0x13)  // Supervisor mode
#define HW_PSR_MON_MODE             NN_KERN_UL(0x16)  // Monitor mode
#define HW_PSR_ABORT_MODE           NN_KERN_UL(0x17)  // Abort mode (prefetch/Data)
#define HW_PSR_HYP_MODE             NN_KERN_UL(0x1a)  // Hyp mode
#define HW_PSR_UNDEF_MODE           NN_KERN_UL(0x1b)  // Undefined instruction mode
#define HW_PSR_SYS_MODE             NN_KERN_UL(0x1f)  // System mode

// AArch32
#define HW_PSR_ARM_STATE            NN_KERN_UL(0x00)  // ARM state
#define HW_PSR_THUMB_STATE          NN_KERN_UL(0x20)  // Thumb state

#define HW_PSR_FIQ_DISABLE          NN_KERN_UL(0x40)  // FIQ Disable
#define HW_PSR_IRQ_DISABLE          NN_KERN_UL(0x80)  // IRQ Disable
#define HW_PSR_IRQ_FIQ_DISABLE      NN_KERN_UL(0xc0)  // IRQ & FIQ Disable
#define HW_PSR_IRQ_DISABLE_SHIFT    7       // HW_PSR_IRQ_DISABLE == (1 << PSR_IRQ_DISABLE_SHIFT)

#define HW_PSR_AARCH32              NN_KERN_UL(0x10)
#define HW_PSR_AARCH64              NN_KERN_UL(0x00)
#define HW_PSR_AARCH_MASK           NN_KERN_UL(0x10)

#define HW_PSR_EL0_MASK             NN_KERN_UL(0xFF0FFE20)


#define HW_MPIDR_EL1_AFF0_MASK      NN_KERN_UL(0xFF)


#define HW_CPACR_EL1_FEN_SHIFT      20
#define HW_CPACR_EL1_FEN_MASK       (NN_KERN_UL(0x3) << HW_CPACR_EL1_FEN_SHIFT)
#define HW_CPACR_EL1_FEN_DISABLE    (NN_KERN_UL(0x0) << HW_CPACR_EL1_FEN_SHIFT)
#define HW_CPACR_EL1_FEN_EL1_ENABLE (NN_KERN_UL(0x1) << HW_CPACR_EL1_FEN_SHIFT)
#define HW_CPACR_EL1_FEN_ENABLE     (NN_KERN_UL(0x3) << HW_CPACR_EL1_FEN_SHIFT)


#define HW_FPCR_AHP                 (NN_KERN_UL(1)<<26)
#define HW_FPCR_DN                  (NN_KERN_UL(1)<<25)
#define HW_FPCR_FZ                  (NN_KERN_UL(1)<<24)
#define HW_FPCR_RMODE_NEAR          (NN_KERN_UL(0)<<22)
#define HW_FPCR_RMODE_PLUS          (NN_KERN_UL(1)<<22)
#define HW_FPCR_RMODE_MINUS         (NN_KERN_UL(2)<<22)
#define HW_FPCR_RMODE_ZERO          (NN_KERN_UL(3)<<22)

#define HW_ESR_EC_SHIFT 26
#define HW_ESR_EC_MASK  NN_KERN_UL(0xFC000000)
#define HW_ESR_IL       NN_KERN_UL(0x02000000)
#define HW_ESR_IL_SHIFT 25
#define HW_ESR_ISS_MASK NN_KERN_UL(0x01FFFFFF)

#define HW_ESR_EC_UNKNOWN           NN_KERN_UL(0x00)
#define HW_ESR_EC_ILLEGAL_EXECUTION NN_KERN_UL(0x0e)
#define HW_ESR_EC_SVC32             NN_KERN_UL(0x11)
#define HW_ESR_EC_SVC64             NN_KERN_UL(0x15)
#define HW_ESR_EC_CP15_MCR_MRC      NN_KERN_UL(0x03)
#define HW_ESR_EC_CP15_MCRR_MRRC    NN_KERN_UL(0x04)
#define HW_ESR_EC_CP14_MCR_MRC      NN_KERN_UL(0x05)
#define HW_ESR_EC_CP14_MRRC         NN_KERN_UL(0x0C)
#define HW_ESR_EC_SYSINST64         NN_KERN_UL(0x18)

#define HW_ESR_EC_FPEXC32           NN_KERN_UL(0x28)
#define HW_ESR_EC_FPEXC64           NN_KERN_UL(0x2c)
#define HW_ESR_EC_FPACC             NN_KERN_UL(0x07)

#define HW_ESR_EC_IABORT_EL0        NN_KERN_UL(0x20)
#define HW_ESR_EC_IABORT_EL1        NN_KERN_UL(0x21)
#define HW_ESR_EC_MISALIGN_PC       NN_KERN_UL(0x22)
#define HW_ESR_EC_DABORT_EL0        NN_KERN_UL(0x24)
#define HW_ESR_EC_DABORT_EL1        NN_KERN_UL(0x25)
#define HW_ESR_EC_MISALIGN_SP       NN_KERN_UL(0x26)
#define HW_ESR_EC_SERROR_INTERRUPT  NN_KERN_UL(0x2F)
#define HW_ESR_EC_BREAKPOINT        NN_KERN_UL(0x30)
#define HW_ESR_EC_STEP              NN_KERN_UL(0x32)
#define HW_ESR_EC_WATCHPOINT        NN_KERN_UL(0x34)
#define HW_ESR_EC_BKPT              NN_KERN_UL(0x38)
#define HW_ESR_EC_BRK               NN_KERN_UL(0x3c)

#define HW_ESR_EC_SERROR_INTERRUPT  NN_KERN_UL(0x2F)

#define HW_SCTLR_UCI                (NN_KERN_UL(0x1)<<26)
#define HW_SCTLR_EE_MASK            (NN_KERN_UL(0x1)<<25)
#define HW_SCTLR_EE_LITTLE          (NN_KERN_UL(0x0)<<25)
#define HW_SCTLR_EE_BIG             (NN_KERN_UL(0x1)<<25)
#define HW_SCTLR_E0E_MASK           (NN_KERN_UL(0x1)<<24)
#define HW_SCTLR_E0E_LITTLE         (NN_KERN_UL(0x0)<<24)
#define HW_SCTLR_E0E_BIG            (NN_KERN_UL(0x1)<<24)
#define HW_SCTLR_WXN                (NN_KERN_UL(0x1)<<19)
#define HW_SCTLR_NTWE               (NN_KERN_UL(0x1)<<18)
#define HW_SCTLR_NTWI               (NN_KERN_UL(0x1)<<16)
#define HW_SCTLR_UCT                (NN_KERN_UL(0x1)<<15)
#define HW_SCTLR_DZE                (NN_KERN_UL(0x1)<<14)
#define HW_SCTLR_I                  (NN_KERN_UL(0x1)<<12)
#define HW_SCTLR_UMA                (NN_KERN_UL(0x1)<<9)
#define HW_SCTLR_SED                (NN_KERN_UL(0x1)<<8)
#define HW_SCTLR_ITD                (NN_KERN_UL(0x1)<<7)
#define HW_SCTLR_CP15BEN            (NN_KERN_UL(0x1)<<5)
#define HW_SCTLR_SA0                (NN_KERN_UL(0x1)<<4)
#define HW_SCTLR_SA                 (NN_KERN_UL(0x1)<<3)
#define HW_SCTLR_C                  (NN_KERN_UL(0x1)<<2)
#define HW_SCTLR_A                  (NN_KERN_UL(0x1)<<1)
#define HW_SCTLR_M                  (NN_KERN_UL(0x1)<<0)
#define HW_SCTLR_RES1               NN_KERN_UL(0x30D00800)


#if defined(NN_BUILD_CONFIG_CPU_CORTEX_A53_AARCH64)
#define HW_CPUECTLR_SMPEN               (NN_KERN_UL(0x1)<<6)
#define HW_CPUECTLR_FP_RETENTION_0      (NN_KERN_UL(0x0)<<3)
#define HW_CPUECTLR_FP_RETENTION_2      (NN_KERN_UL(0x1)<<3)
#define HW_CPUECTLR_FP_RETENTION_8      (NN_KERN_UL(0x2)<<3)
#define HW_CPUECTLR_FP_RETENTION_32     (NN_KERN_UL(0x3)<<3)
#define HW_CPUECTLR_FP_RETENTION_64     (NN_KERN_UL(0x4)<<3)
#define HW_CPUECTLR_FP_RETENTION_128    (NN_KERN_UL(0x5)<<3)
#define HW_CPUECTLR_FP_RETENTION_256    (NN_KERN_UL(0x6)<<3)
#define HW_CPUECTLR_FP_RETENTION_512    (NN_KERN_UL(0x7)<<3)
#define HW_CPUECTLR_CPU_RETENTION_0     (NN_KERN_UL(0x0)<<0)
#define HW_CPUECTLR_CPU_RETENTION_2     (NN_KERN_UL(0x1)<<0)
#define HW_CPUECTLR_CPU_RETENTION_8     (NN_KERN_UL(0x2)<<0)
#define HW_CPUECTLR_CPU_RETENTION_32    (NN_KERN_UL(0x3)<<0)
#define HW_CPUECTLR_CPU_RETENTION_64    (NN_KERN_UL(0x4)<<0)
#define HW_CPUECTLR_CPU_RETENTION_128   (NN_KERN_UL(0x5)<<0)
#define HW_CPUECTLR_CPU_RETENTION_256   (NN_KERN_UL(0x6)<<0)
#define HW_CPUECTLR_CPU_RETENTION_512   (NN_KERN_UL(0x7)<<0)

#define HW_CPUACTLR_FPDIDIS             (NN_KERN_UL(0x1)<<30)
#define HW_CPUACTLR_DIDIS               (NN_KERN_UL(0x1)<<29)
#define HW_CPUACTLR_RADIS_16            (NN_KERN_UL(0x0)<<27)
#define HW_CPUACTLR_RADIS_128           (NN_KERN_UL(0x1)<<27)
#define HW_CPUACTLR_RADIS_512           (NN_KERN_UL(0x2)<<27)
#define HW_CPUACTLR_RADIS_DISABLE       (NN_KERN_UL(0x3)<<27)
#define HW_CPUACTLR_L1RADIS_4           (NN_KERN_UL(0x0)<<25)
#define HW_CPUACTLR_L1RADIS_64          (NN_KERN_UL(0x1)<<25)
#define HW_CPUACTLR_L1RADIS_128         (NN_KERN_UL(0x2)<<25)
#define HW_CPUACTLR_L1RADIS_DISABLE     (NN_KERN_UL(0x3)<<25)
#define HW_CPUACTLR_DTAH                (NN_KERN_UL(0x1)<<24)
#define HW_CPUACTLR_STBPFRS             (NN_KERN_UL(0x1)<<23)
#define HW_CPUACTLR_STBPFDIS            (NN_KERN_UL(0x1)<<22)
#define HW_CPUACTLR_IFUTHDIS            (NN_KERN_UL(0x1)<<21)
#define HW_CPUACTLR_NPFSTRM_1           (NN_KERN_UL(0x0)<<19)
#define HW_CPUACTLR_NPFSTRM_2           (NN_KERN_UL(0x1)<<19)
#define HW_CPUACTLR_NPFSTRM_3           (NN_KERN_UL(0x2)<<19)
#define HW_CPUACTLR_NPFSTRM_4           (NN_KERN_UL(0x3)<<19)
#define HW_CPUACTLR_DSTDIS              (NN_KERN_UL(0x1)<<18)
#define HW_CPUACTLR_STRIDE_2            (NN_KERN_UL(0x0)<<17)
#define HW_CPUACTLR_STRIDE_3            (NN_KERN_UL(0x1)<<17)
#define HW_CPUACTLR_L1PCTL_DISABLE      (NN_KERN_UL(0x0)<<13)
#define HW_CPUACTLR_L1PCTL_1            (NN_KERN_UL(0x1)<<13)
#define HW_CPUACTLR_L1PCTL_2            (NN_KERN_UL(0x2)<<13)
#define HW_CPUACTLR_L1PCTL_3            (NN_KERN_UL(0x3)<<13)
#define HW_CPUACTLR_L1PCTL_4            (NN_KERN_UL(0x4)<<13)
#define HW_CPUACTLR_L1PCTL_5            (NN_KERN_UL(0x5)<<13)
#define HW_CPUACTLR_L1PCTL_6            (NN_KERN_UL(0x6)<<13)
#define HW_CPUACTLR_L1PCTL_8            (NN_KERN_UL(0x7)<<13)
#define HW_CPUACTLR_DODMBS              (NN_KERN_UL(0x1)<<10)
#elif defined(NN_BUILD_CONFIG_CPU_CORTEX_A57_AARCH64)
#define HW_CPUECTLR_DISABLE_TABLE_WALK_PREFETCH         (NN_KERN_UL(0x1)<<38)
#define HW_CPUECTLR_L2_INST_PREFETCH_DISTANCE_0         (NN_KERN_UL(0x0)<<35)
#define HW_CPUECTLR_L2_INST_PREFETCH_DISTANCE_1         (NN_KERN_UL(0x1)<<35)
#define HW_CPUECTLR_L2_INST_PREFETCH_DISTANCE_2         (NN_KERN_UL(0x2)<<35)
#define HW_CPUECTLR_L2_INST_PREFETCH_DISTANCE_3         (NN_KERN_UL(0x3)<<35)
#define HW_CPUECTLR_L2_DATA_PREFETCH_DISTANCE_0         (NN_KERN_UL(0x0)<<32)
#define HW_CPUECTLR_L2_DATA_PREFETCH_DISTANCE_2         (NN_KERN_UL(0x1)<<32)
#define HW_CPUECTLR_L2_DATA_PREFETCH_DISTANCE_4         (NN_KERN_UL(0x2)<<32)
#define HW_CPUECTLR_L2_DATA_PREFETCH_DISTANCE_8         (NN_KERN_UL(0x3)<<32)
#define HW_CPUECTLR_SMPEN                               (NN_KERN_UL(0x1)<<6)
#define HW_CPUECTLR_CPU_RETENTION_0                     (NN_KERN_UL(0x0)<<0)
#define HW_CPUECTLR_CPU_RETENTION_2                     (NN_KERN_UL(0x1)<<0)
#define HW_CPUECTLR_CPU_RETENTION_8                     (NN_KERN_UL(0x2)<<0)
#define HW_CPUECTLR_CPU_RETENTION_32                    (NN_KERN_UL(0x3)<<0)
#define HW_CPUECTLR_CPU_RETENTION_64                    (NN_KERN_UL(0x4)<<0)
#define HW_CPUECTLR_CPU_RETENTION_128                   (NN_KERN_UL(0x5)<<0)
#define HW_CPUECTLR_CPU_RETENTION_256                   (NN_KERN_UL(0x6)<<0)
#define HW_CPUECTLR_CPU_RETENTION_512                   (NN_KERN_UL(0x7)<<0)

#define HW_CPUACTLR_RADIS_12                            (NN_KERN_UL(0x0)<<27)
#define HW_CPUACTLR_RADIS_128                           (NN_KERN_UL(0x1)<<27)
#define HW_CPUACTLR_RADIS_512                           (NN_KERN_UL(0x2)<<27)
#define HW_CPUACTLR_RADIS_DISABLE                       (NN_KERN_UL(0x3)<<27)
#define HW_CPUACTLR_L1RADIS_4                           (NN_KERN_UL(0x0)<<25)
#define HW_CPUACTLR_L1RADIS_64                          (NN_KERN_UL(0x1)<<25)
#define HW_CPUACTLR_L1RADIS_128                         (NN_KERN_UL(0x2)<<25)
#define HW_CPUACTLR_L1RADIS_DISABLE                     (NN_KERN_UL(0x3)<<25)
#define HW_CPUACTLR_NON_CACHEABLE_STREAMING_ENHANCEMENT (NN_KERN_UL(0x1)<<24)

#else
#error not defined NN_BUILD_CONFIG_CPU
#endif

#define HW_TCR_TBI1                     (NN_KERN_UL(0x1)<<38)
#define HW_TCR_TBI0                     (NN_KERN_UL(0x1)<<37)
#define HW_TCR_AS_8BIT                  (NN_KERN_UL(0x0)<<36)
#define HW_TCR_AS_16BIT                 (NN_KERN_UL(0x1)<<36)
#define HW_TCR_IPS_4G                   (NN_KERN_UL(0x0)<<32)
#define HW_TCR_IPS_64G                  (NN_KERN_UL(0x1)<<32)
#define HW_TCR_IPS_1T                   (NN_KERN_UL(0x2)<<32)
#define HW_TCR_IPS_4T                   (NN_KERN_UL(0x3)<<32)
#define HW_TCR_IPS_16T                  (NN_KERN_UL(0x4)<<32)
#define HW_TCR_IPS_256T                 (NN_KERN_UL(0x5)<<32)
#define HW_TCR_TG1_4K                   (NN_KERN_UL(0x2)<<30)
#define HW_TCR_TG1_64K                  (NN_KERN_UL(0x3)<<30)
#define HW_TCR_SH1_NON_SHARE            (NN_KERN_UL(0x0)<<28)
#define HW_TCR_SH1_OUTER_SHARE          (NN_KERN_UL(0x2)<<28)
#define HW_TCR_SH1_INNER_SHARE          (NN_KERN_UL(0x3)<<28)
#define HW_TCR_ORGN1_NON_CACHE          (NN_KERN_UL(0x0)<<26)
#define HW_TCR_ORGN1_WBWA_CACHE         (NN_KERN_UL(0x1)<<26)
#define HW_TCR_ORGN1_WT_CACHE           (NN_KERN_UL(0x2)<<26)
#define HW_TCR_ORGN1_WB_CACHE           (NN_KERN_UL(0x3)<<26)
#define HW_TCR_IRGN1_NON_CACHE          (NN_KERN_UL(0x0)<<24)
#define HW_TCR_IRGN1_WBWA_CACHE         (NN_KERN_UL(0x1)<<24)
#define HW_TCR_IRGN1_WT_CACHE           (NN_KERN_UL(0x2)<<24)
#define HW_TCR_IRGN1_WB_CACHE           (NN_KERN_UL(0x3)<<24)
#define HW_TCR_EPD1                     (NN_KERN_UL(0x1)<<23)
#define HW_TCR_A1_TTBR0                 (NN_KERN_UL(0x0)<<22)
#define HW_TCR_A1_TTBR1                 (NN_KERN_UL(0x1)<<22)
#define HW_TCR_T1SZ(x)                  ((x)<<16)
#define HW_TCR_TG0_4K                   (NN_KERN_UL(0x0)<<14)
#define HW_TCR_TG0_64K                  (NN_KERN_UL(0x1)<<14)
#define HW_TCR_SH0_NON_SHARE            (NN_KERN_UL(0x0)<<12)
#define HW_TCR_SH0_OUTER_SHARE          (NN_KERN_UL(0x2)<<12)
#define HW_TCR_SH0_INNER_SHARE          (NN_KERN_UL(0x3)<<12)
#define HW_TCR_ORGN0_NON_CACHE          (NN_KERN_UL(0x0)<<10)
#define HW_TCR_ORGN0_WBWA_CACHE         (NN_KERN_UL(0x1)<<10)
#define HW_TCR_ORGN0_WT_CACHE           (NN_KERN_UL(0x2)<<10)
#define HW_TCR_ORGN0_WB_CACHE           (NN_KERN_UL(0x3)<<10)
#define HW_TCR_IRGN0_NON_CACHE          (NN_KERN_UL(0x0)<<8)
#define HW_TCR_IRGN0_WBWA_CACHE         (NN_KERN_UL(0x1)<<8)
#define HW_TCR_IRGN0_WT_CACHE           (NN_KERN_UL(0x2)<<8)
#define HW_TCR_IRGN0_WB_CACHE           (NN_KERN_UL(0x3)<<8)
#define HW_TCR_EPD0                     (NN_KERN_UL(0x1)<<7)
#define HW_TCR_T0SZ(x)                  ((x)<<0)
#define HW_TCR_T0SZ_MASK                (NN_KERN_UL(0x3F)<<0)

#define HW_CNTKCTL_EL0PTEN              (NN_KERN_UL(1)<<9)
#define HW_CNTKCTL_EL0VTEN              (NN_KERN_UL(1)<<8)
#define HW_CNTKCTL_EVNTI_0              (NN_KERN_UL(0)<<4)
#define HW_CNTKCTL_EVNTI_1              (NN_KERN_UL(1)<<4)
#define HW_CNTKCTL_EVNTI_2              (NN_KERN_UL(2)<<4)
#define HW_CNTKCTL_EVNTI_3              (NN_KERN_UL(3)<<4)
#define HW_CNTKCTL_EVNTI_4              (NN_KERN_UL(4)<<4)
#define HW_CNTKCTL_EVNTI_5              (NN_KERN_UL(5)<<4)
#define HW_CNTKCTL_EVNTI_6              (NN_KERN_UL(6)<<4)
#define HW_CNTKCTL_EVNTI_7              (NN_KERN_UL(7)<<4)
#define HW_CNTKCTL_EVNTI_8              (NN_KERN_UL(8)<<4)
#define HW_CNTKCTL_EVNTI_9              (NN_KERN_UL(9)<<4)
#define HW_CNTKCTL_EVNTI_10             (NN_KERN_UL(10)<<4)
#define HW_CNTKCTL_EVNTI_11             (NN_KERN_UL(11)<<4)
#define HW_CNTKCTL_EVNTI_12             (NN_KERN_UL(12)<<4)
#define HW_CNTKCTL_EVNTI_13             (NN_KERN_UL(13)<<4)
#define HW_CNTKCTL_EVNTI_14             (NN_KERN_UL(14)<<4)
#define HW_CNTKCTL_EVNTI_15             (NN_KERN_UL(15)<<4)
#define HW_CNTKCTL_EVNTDIR              (NN_KERN_UL(1)<<3)
#define HW_CNTKCTL_EVNTEN               (NN_KERN_UL(1)<<2)
#define HW_CNTKCTL_EL0VCTEN             (NN_KERN_UL(1)<<1)
#define HW_CNTKCTL_EL0PCTEN             (NN_KERN_UL(1)<<0)

#define HW_PMCCFILTR(el0, el1)          static_cast<uint64_t>(((!(el1) << 31)) | ((!(el0) << 30)))
#define HW_PMXEVTYPER(el0, el1, type)   static_cast<uint64_t>(((!(el1) << 31)) | ((!(el0) << 30)) | (((type) & 0x3FF)))

#define HW_PM_TYPE_INST_RETIRED         0x08
#define HW_PM_TYPE_CPU_CYCLES           0x11
#define HW_PM_TYPE_L2C_REFILL           0x17


#define HW_MAIR_ATTR_DEVICE_NGNRNE      NN_KERN_UL(0x00)
#define HW_MAIR_ATTR_DEVICE_NGNRE       NN_KERN_UL(0x04)

// Normal Memory
//      Inner Cacheable write allocate read allocate
//      Outer Cacheable write allocate read allocate
#define HW_MAIR_ATTR_NORMAL_ICRW_OCRW   NN_KERN_UL(0xFF)
#define HW_MAIR_ATTR_NORMAL_INC_ONC     NN_KERN_UL(0x44)

