﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "kern_AssemblyOffset.h"
#include "../ARM/kern_Assembly.h"

#if NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 32
#define SAVE_FPU_REGISTERES(base)       \
    fstmiad base!, { d0-d15 };          \
    fstmiad base!, { d16-d31 }
#define RESTORE_FPU_REGISTERES(base)    \
    fldmiad base!, { d0-d15 };          \
    fldmiad base!, { d16-d31 }
#elif NN_BUILD_CONFIG_FPU_NUM_DOUBLE_REGISTERS == 16
#define SAVE_FPU_REGISTERES(base)       \
    fstmiad base!, { d0-d15 }
#define RESTORE_FPU_REGISTERES(base)    \
    fldmiad base!, { d0-d15 }
#else
#define SAVE_FPU_REGISTERES(base)
#define RESTORE_FPU_REGISTERES(base)
#endif

#define SAVE_CONTEXT(ctx, tmp0)                                         \
    stmia   ctx, { r4-r11, sp, lr };                                    \
    fmrx    tmp0, fpexc;                                                \
    str     tmp0, [ctx, #KCONTEXT_FPEXC];                               \
    and     tmp0, tmp0, #HW_FPEXC_VFP_ENABLE;                           \
    cmp     tmp0, #0;                                                   \
    beq     .Lskip_vfp_save;                                            \
    add     tmp0, ctx, #KCONTEXT_FPUREGISTERS;                          \
    SAVE_FPU_REGISTERES(tmp0);                                          \
.Lskip_vfp_save:;

#define RESTORE_CONTEXT(ctx, tmp0)                                      \
    ldr     tmp0, [ctx, #KCONTEXT_FPEXC];                               \
    fmxr    fpexc, tmp0;                                                \
    isb;                                                                \
    and     tmp0, tmp0, #HW_FPEXC_VFP_ENABLE;                           \
    cmp     tmp0, #0;                                                   \
    beq     .Lskip_vfp_restore;                                         \
    add     tmp0, ctx, #KCONTEXT_FPUREGISTERS;                          \
    RESTORE_FPU_REGISTERES(tmp0);                                       \
    ldr     tmp0, [ctx, #KCONTEXT_FPSCR];                               \
    fmxr    fpscr, tmp0;                                                \
.Lskip_vfp_restore:;                                                    \
    ldmia   ctx, { r4-r11, r13, r14 };



ENTRY(_ZN2nn4kern10KScheduler8ScheduleEPNS1_17SchedulingCounterE)
    // カレントスレッドの KContext へのポインタを計算
    mov     r3, #1
    add     r3, r3, sp, LSR #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    mov     r3, r3, LSL #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    ldr     r2, [r3, #-(PARAMS_ON_STACK_SIZE - PARAMS_ON_STACK_CONTEXT)]

    SAVE_CONTEXT(r2, r12)

    mov     r4, r0
    mov     r5, r1

    // スタック切り替え
    ldr     r0, [r5, #KSCHEDULER_IDLE_STASK]
    mov     sp, r0
.Lreschdule:
    // r2: ctx
    // r3: sp end
    // r4: this
    // r5: SchedulingCounter

    ldrb    r0, [r5, #KSCHEDULER_INTERRUPTTASK_IS_RUNNABLE]
    cmp     r0, #0
    beq     .Linterrupt_checked
    mov     r1, #0
    strb    r1, [r5, #KSCHEDULER_INTERRUPTTASK_IS_RUNNABLE]

    mov     r0, r4
    mov     r6, r2
    mov     r7, r3
    bl      _ZN2nn4kern10KScheduler29InterruptTaskThreadToRunnableEv
    mov     r2, r6
    mov     r3, r7

.Linterrupt_checked:
    cmp     r3, #0
    beq     .Lskip_unlock

    // 終了されたスレッドはロックを解除しない
    ldrb    r0, [r3, #-(PARAMS_ON_STACK_SIZE - PARAMS_ON_STACK_DPCFLAGS)]
    ands    r0, r0, #(1 << DPC_FUNC_TERMINATED_SHIFT)
    bne     .Lskip_unlock

    dmb     ish
    mov     r0, #0
    strb    r0, [r2, #KCONTEXT_LOCK]
.Lskip_unlock:
    // r4: this
    // r5: SchedulingCounter
    clrex
    dmb     ish
    mov     r0, #0
    strb    r0, [r5, #KSCHEDULER_SCHEDULING_REQUIRED]

    ldr     r6, [r5, #KSCHEDULER_HIGHEST_THREAD]
    cmp     r6, #0
    beq     .Lswitch_idle

    mov     r0, r6
    bl      _ZN2nn4kern7KThread17GetContextPointerEv
    mov     r7, r0

    // 次のコンテキストの ロック獲得
    // r4: this
    // r5: SchedulingCounter
    // r6: pNextThread
    // r7: pNextCtx

    add     r1, r7, #KCONTEXT_LOCK
    mov     r3, #1
.Llock_loop0:
    sev
.Llock_loop1:
    wfe
    ldrexb  r0, [r1]
    cmp     r0, #0
    bne     .Lcheck_resh
    strexb  r0, r3, [r1]
    cmp     r0, #0
    bne     .Llock_loop1
    dmb     ish
    b       .Llocked

.Lcheck_resh:
    ldrb    r0, [r5, #KSCHEDULER_SCHEDULING_REQUIRED]
    dmb     ish
    cmp     r0, #0
    beq     .Llock_loop0

    // アイドルにスイッチしてから割り込みチェック
    mov     r0, r4
    mov     r1, #0
    bl      _ZN2nn4kern10KScheduler12SwitchThreadEPNS0_7KThreadE
    mov     r3, #0
    b       .Lreschdule

.Llocked:
    mov     r0, r4
    mov     r1, r6
    bl      _ZN2nn4kern10KScheduler12SwitchThreadEPNS0_7KThreadE
    cmp     r0, #0
    beq     .Lrestore_noctx

    mov     r0, r4
    mov     r1, r5
    mov     r2, r7
    RESTORE_CONTEXT(r2, r3)
    b       .Lrestore_end

.Lrestore_noctx:
    // スケジューラで破壊したコンテキストを復帰
    mov     r0, r4
    mov     r1, r5
    mov     r2, r7
    ldr     r4, [r2, #(KCONTEXT_CPUREGISTERS + 0 * 4)]
    ldr     r5, [r2, #(KCONTEXT_CPUREGISTERS + 1 * 4)]
    ldr     r6, [r2, #(KCONTEXT_CPUREGISTERS + 2 * 4)]
    ldr     r7, [r2, #(KCONTEXT_CPUREGISTERS + 3 * 4)]
    ldr     lr, [r2, #(KCONTEXT_LR)]
    ldr     ip, [r2, #(KCONTEXT_SP)]
    mov     sp, ip

.Lrestore_end:
    // r0: this
    // r1: SchedulingCounter
    // r2: ctx

    ldrb    r3, [r1, #KSCHEDULER_SCHEDULING_REQUIRED]
    dmb     ish
    cmp     r3, #0
    bne     .Lrestore_without_restore

    bx      lr

    // もう一度スケジューリングをやり直す
.Lrestore_without_restore:
    mov     r4, r0
    mov     r5, r1

    // スタック切り替え
    mov     r3, #1
    add     r3, r3, sp, LSR #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    mov     r3, r3, LSL #NN_KERN_THREAD_SVC_STACK_SIZE_SHIFT
    ldr     r2, [r3, #-(PARAMS_ON_STACK_SIZE - PARAMS_ON_STACK_CONTEXT)]

    // スタック切り替え
    ldr     r5, [r5, #KSCHEDULER_IDLE_STASK]
    mov     sp, r5
    b       .Lreschdule

.Lswitch_idle:
    // アイドルにスイッチ
    // r4: this
    // r5: SchedulingCounter
    mov     r0, r4
    mov     r1, #0
    bl      _ZN2nn4kern10KScheduler12SwitchThreadEPNS0_7KThreadE

.Lidle_loop:
    ldrb    r0, [r5, #KSCHEDULER_SCHEDULING_REQUIRED]
    dmb     ish
    cmp     r0, #0
    bne     .Lidle_loop_end

    wfi
    cpsie   i
    cpsid   i

    b       .Lidle_loop
.Lidle_loop_end:
    mov     r3, #0
    b       .Lreschdule
SET_SIZE(_ZN2nn4kern10KScheduler8ScheduleEPNS1_17SchedulingCounterE)

