﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

#ifndef NN_KERN_CALC_END
#define NN_KERN_CALC_END(name)      ((name) + (name ## _SIZE))
#define NN_KERN_CALC_SIZE(name)     ((name ## _END) - (name))
#define NN_KERN_CALC_HEAD(name)     ((name ## _END) - (name ## _SIZE))
#endif

#ifndef NN_KERN_UL
#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ull
#endif
#endif


#define NN_KERN_DETAIL_RAMDISK_OFFSET   NN_KERN_UL(0)

