﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef NN_SWITCH_INCLUDE_FROM_NON_C
#include <nn/nn_Common.h>
#endif

// マクロの展開で失敗するようなら展開してしまうこと
#define NN_KERN_CALC_END(name)      ((name) + (name ## _SIZE))
#define NN_KERN_CALC_SIZE(name)     ((name ## _END) - (name))
#define NN_KERN_CALC_HEAD(name)     ((name ## _END) - (name ## _SIZE))

#ifdef NN_SWITCH_INCLUDE_FROM_NON_C
#define NN_KERN_UL(x)       (x)
#else
#define NN_KERN_UL(x)       x ## ul
#endif

//---------------------------------------------------------------------------
// 物理アドレス
// CortexA15 プライベート領域
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION       0x50040000
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_SIZE  0x8000
#define NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION_END   NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION )

#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER               NN_KERN_UL(NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION + 0x1000)
#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_SIZE          NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER_END           NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_GIC_DISTRIBUTER )
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE                 NN_KERN_UL(NN_KERN_DETAIL_P_ADDR_CORE_PRIVATE_REGION + 0x2000)
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_SIZE            NN_KERN_UL(0x1000)
#define NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE_END             NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_CPU_INTERFACE )

// MAIN_MEMORY (0x80000000 - 0xFFFFFFFF のうち 0xC0000000 - 0xDFFFFFFF を使用する)
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY               0xC0000000
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_SIZE          0x40000000
#define NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY_END           NN_KERN_CALC_END( NN_KERN_DETAIL_P_ADDR_MAIN_MEMORY )
#define NN_KERN_DETAIL_P_ADDR_RESERVED_LO_SIZE          0x00000000
#define NN_KERN_DETAIL_P_ADDR_RESERVED_HI_SIZE          0x00000000

// UART0
#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER            0x70006000
#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER_SIZE       0x1000
#define NN_KERN_DETAIL_P_ADDR_UART0_REGISTER_END        NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_UART0_REGISTER)

#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER               0x70019000
#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER_SIZE          0x1000
#define NN_KERN_DETAIL_P_ADDR_MC_REGISTER_END           NN_KERN_CALC_END(NN_KERN_DETAIL_P_ADDR_MC_REGISTER)

