﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/svc/svc_Kernel.h>
#include "../../kern_Platform.h"
#include "../../kern_KInterruptTask.h"
#include "../../kern_KMemoryManager.h"
#include "../common/kern_SystemControlBase.h"

namespace nn { namespace kern {

    // NX 版固有実装
    class KSystemControl : public KSystemControlBase
    {
    public:
        static KMemoryManager::Region GetCreateProcessMemoryRegion();
        static void GetHeapArrange(KHeapArrange* p);
        static void SystemInitialize0();
        static void SystemInitialize1();
        static void CallSecureMonitor64(Bit64* pBuf);
        //static void CallSecureMonitor32(Bit32* pBuf); // NX は 64bit のみ
        static void SleepSystem();
        static uint64_t GetRandomValue(uint64_t randMin, uint64_t randMax);
        static void GenerateRandom(Bit64* pBuffer, size_t num);
        static Result ReadWriteRegister(Bit32* pOut, nn::svc::PhysicalAddress address, Bit32 mask, Bit32 value);
        static NN_NORETURN void StopSystem();
        static bool IsIoMappablePhysicalAddress(KPhysicalAddress addr, size_t size);
        static bool IsStaticMappablePhysicalAddress(KPhysicalAddress addr, size_t size);

        static size_t ComputeMemoryRequirementForSecureMemory(size_t size, KMemoryManager::Region region);
        static Result AllocateSecureMemory(KVirtualAddress* pAddr, size_t size, KMemoryManager::Region region);
        static void FreeSecureMemory(KVirtualAddress addr, size_t size, KMemoryManager::Region region);

        // NX 固有 API
        static void ReadWriteRegisterFromKernel(Bit32* pOut, nn::svc::PhysicalAddress address, Bit32 mask, Bit32 value);
        static void CpuSleepHandler(uint64_t arg, uint64_t entry);
        static void ResumeEntry(uint64_t arg);
    };

    class KTargetSystem : public KTargetSystemBase
    {
    };

}}

