﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   多重待ちに関する C 言語用の型や定数の宣言
 */

#pragma once

#include <nnc/nn_Common.h>
#include <nnc/os/os_Macro.h>
#include <nnc/os/detail/os_MacroImpl.h>

#include <nn/os/detail/os_TypesDefinition.h>

//--------------------------------------------------------------------------
//  C 向けの宣言
//--------------------------------------------------------------------------

NN_OS_DETAIL_DEFINE_ALIGNED_STORAGE(nnosMultiWaitType,       nn::os::MultiWaitType,       NN_OS_SIZEOF_MULTI_WAIT_TYPE,        uint64_t);
NN_OS_DETAIL_DEFINE_ALIGNED_STORAGE(nnosMultiWaitHolderType, nn::os::MultiWaitHolderType, NN_OS_SIZEOF_MULTI_WAIT_HOLDER_TYPE, void*);
