﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   メモリフェンス機能に関する C 言語用 API の宣言
 */

#pragma once

#include <nn/os/os_Config.h>

#include <nnc/nn_Common.h>
#include <nnc/nn_Macro.h>


#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include <nnc/os/detail/os_MemoryFenceApi-os.win32.h>
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
    #include <nnc/os/detail/os_MemoryFenceApi-os.horizon.h>
#endif

#ifndef __cplusplus

//! @name メモリフェンス関連 API
//! @{

//--------------------------------------------------------------------------
/**
 * @brief   Store-Store メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Store-Store メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryStoreStore()
{
    nnosdetailFenceMemoryStoreStore();
}

//--------------------------------------------------------------------------
/**
 * @brief   Store-Load メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Store-Load メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryStoreLoad()
{
    nnosdetailFenceMemoryStoreLoad();
}

//--------------------------------------------------------------------------
/**
 * @brief   Store-Any メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Store-Any メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryStoreAny()
{
    nnosdetailFenceMemoryStoreAny();
}

//--------------------------------------------------------------------------
/**
 * @brief   Load-Store メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Load-Store メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryLoadStore()
{
    nnosdetailFenceMemoryLoadStore();
}

//--------------------------------------------------------------------------
/**
 * @brief   Load-Load メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Load-Load メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryLoadLoad()
{
    nnosdetailFenceMemoryLoadLoad();
}

//--------------------------------------------------------------------------
/**
 * @brief   Load-Any メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Load-Any メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryLoadAny()
{
    nnosdetailFenceMemoryLoadAny();
}

//--------------------------------------------------------------------------
/**
 * @brief   Any-Store メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Any-Store メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryAnyStore()
{
    nnosdetailFenceMemoryAnyStore();
}

//--------------------------------------------------------------------------
/**
 * @brief   Any-Load メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Any-Load メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryAnyLoad()
{
    nnosdetailFenceMemoryAnyLoad();
}

//--------------------------------------------------------------------------
/**
 * @brief   Any-Any メモリフェンスを挿入します。
 *
 * @details
 *  本 API 呼び出しが配置された場所に Any-Any メモリフェンスを挿入します。
 *  詳細は @ref PageNotificationOsMemoryFence を参照して下さい。
 *
 */
static NNC_FORCEINLINE void nnosFenceMemoryAnyAny()
{
    nnosdetailFenceMemoryAnyAny();
}

#endif // __cplusplus

//! @}
