﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      tsc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_TSC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_TSC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_TSC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_TSC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_TSC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_TSC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_TSC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_TSC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_TSC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_TSC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_TSC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_TSC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_TSC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_TSC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_TSC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_TSC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_TSC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_TSC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_TSC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_TSC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(tsc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_TSC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Trace, 0, format, args)
#define NN_DETAIL_TSC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Trace, 1, format, args)
#define NN_DETAIL_TSC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Trace, 2, format, args)
#define NN_DETAIL_TSC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Trace, 3, format, args)

#define NN_DETAIL_TSC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Info, 0, format, args)
#define NN_DETAIL_TSC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Info, 1, format, args)
#define NN_DETAIL_TSC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Info, 2, format, args)
#define NN_DETAIL_TSC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Info, 3, format, args)

#define NN_DETAIL_TSC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Warn, 0, format, args)
#define NN_DETAIL_TSC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Warn, 1, format, args)
#define NN_DETAIL_TSC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Warn, 2, format, args)
#define NN_DETAIL_TSC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Warn, 3, format, args)

#define NN_DETAIL_TSC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Error, 0, format, args)
#define NN_DETAIL_TSC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Error, 1, format, args)
#define NN_DETAIL_TSC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Error, 2, format, args)
#define NN_DETAIL_TSC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Error, 3, format, args)

#define NN_DETAIL_TSC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Fatal, 0, format, args)
#define NN_DETAIL_TSC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Fatal, 1, format, args)
#define NN_DETAIL_TSC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Fatal, 2, format, args)
#define NN_DETAIL_TSC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(tsc, Fatal, 3, format, args)

#define NN_DETAIL_TSC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Trace, 0, text, length)
#define NN_DETAIL_TSC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Trace, 1, text, length)
#define NN_DETAIL_TSC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Trace, 2, text, length)
#define NN_DETAIL_TSC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Trace, 3, text, length)

#define NN_DETAIL_TSC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Info, 0, text, length)
#define NN_DETAIL_TSC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Info, 1, text, length)
#define NN_DETAIL_TSC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Info, 2, text, length)
#define NN_DETAIL_TSC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Info, 3, text, length)

#define NN_DETAIL_TSC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Warn, 0, text, length)
#define NN_DETAIL_TSC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Warn, 1, text, length)
#define NN_DETAIL_TSC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Warn, 2, text, length)
#define NN_DETAIL_TSC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Warn, 3, text, length)

#define NN_DETAIL_TSC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Error, 0, text, length)
#define NN_DETAIL_TSC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Error, 1, text, length)
#define NN_DETAIL_TSC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Error, 2, text, length)
#define NN_DETAIL_TSC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Error, 3, text, length)

#define NN_DETAIL_TSC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Fatal, 0, text, length)
#define NN_DETAIL_TSC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Fatal, 1, text, length)
#define NN_DETAIL_TSC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Fatal, 2, text, length)
#define NN_DETAIL_TSC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(tsc, Fatal, 3, text, length)
