﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/spl/spl_Types.h>
#include <nn/spl/smc/spl_SecureMonitorTypes.h>

namespace nn { namespace spl { namespace smc {

    SmcResult ModularExponentiate(
        OperationKey*   pOutOperationKey,
        const void*     pBase,
        const void*     pExponent,
        size_t          exponentSize,
        const void*     pModulus ) NN_NOEXCEPT;

    SmcResult GenerateAesKek(
        AccessKey*  pOutAccessKey,
        const Bit64 pSource[],
        int         generation,
        Bit32       option  ) NN_NOEXCEPT;

    SmcResult LoadAesKey(
        int slotIndex,
        const AccessKey& accessKey,
        const Bit64 pSource[] ) NN_NOEXCEPT;

    SmcResult ComputeAes(
        OperationKey*   pOutOperationKey,
        uint32_t        outputAddress,
        Bit32           mode,
        const Bit64     pIvic[],
        uint32_t        inputAddress,
        size_t          inoutSize ) NN_NOEXCEPT;

    SmcResult ComputeCmac(
        Bit64           pOutMac[],
        int             slotIndex,
        const void*     pInBuffer,
        size_t          inBufferSize ) NN_NOEXCEPT;

    SmcResult GenerateSpecificAesKey(
        Bit64       pResult[],
        const Bit64 pSource[],
        int         generation,
        Bit32       purpose  ) NN_NOEXCEPT;

    SmcResult  GetConfig(
        Bit64       pOutBuffer[],
        int         bufferCount,
        ConfigItem  key ) NN_NOEXCEPT;

    SmcResult  SetConfig(
        OperationKey*   pOutOperationKey,
        ConfigItem      key,
        const Bit64     pValue[],
        int             valueCount,
        const void*     pSign ) NN_NOEXCEPT;

    SmcResult  GenerateRandomBytes(
        void*   pOutBuffer,
        size_t  bufferSize ) NN_NOEXCEPT;

    SmcResult  ModularExponentiateWithStorageKey(
        OperationKey*   pOutOperationKey,
        const void*     pCipher,
        const void*     pModulus,
        Bit32           option) NN_NOEXCEPT;

    SmcResult  DecryptDeviceUniqueData(
        void*            pData,
        size_t           dataSize,
        const AccessKey& accessKey,
        const Bit64      pSource[],
        Bit32            option) NN_NOEXCEPT;

    SmcResult  PrepareEsDeviceUniqueKey(
        OperationKey*    pOutOperationKey,
        const void*      pCipher,
        const void*      pModulus,
        const void*      pLabelDigest,
        size_t           labelDiegstSize,
        Bit32            option) NN_NOEXCEPT;

    SmcResult  PrepareCommonEsTitleKey(
        AccessKey*  pOutAccessKey,
        const Bit64 pSource[],
        int         generation) NN_NOEXCEPT;

    SmcResult  LoadPreparedAesKey(
        int              slotIndex,
        const AccessKey& accessKey) NN_NOEXCEPT;

    SmcResult  ReencryptDeviceUniqueData(
        void*            pData,
        size_t           dataSize,
        const AccessKey& accessKeyForDecryption,
        const Bit64      pSourceForDecryption[],
        const AccessKey& accessKeyForEncryption,
        const Bit64      pSourceForEncryption[],
        Bit32            option) NN_NOEXCEPT;

    SmcResult  GetResult(SmcResult* pOut, OperationKey operationKey) NN_NOEXCEPT;

    SmcResult  GetResultData(
        SmcResult*      pOut,
        void*           pOutBuffer,
        size_t          bufferSize,
        OperationKey    operationKey) NN_NOEXCEPT;

}}}  // namespace nn::spl::smc

