﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      spl モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_SPL_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(spl, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPL_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPL_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPL_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPL_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(spl, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPL_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPL_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPL_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPL_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(spl, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPL_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPL_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPL_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(spl, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPL_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(spl, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPL_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPL_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPL_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPL_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(spl, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_SPL_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_SPL_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_SPL_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(spl, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_SPL_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Trace, 0, format, args)
#define NN_DETAIL_SPL_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Trace, 1, format, args)
#define NN_DETAIL_SPL_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Trace, 2, format, args)
#define NN_DETAIL_SPL_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Trace, 3, format, args)

#define NN_DETAIL_SPL_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Info, 0, format, args)
#define NN_DETAIL_SPL_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Info, 1, format, args)
#define NN_DETAIL_SPL_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Info, 2, format, args)
#define NN_DETAIL_SPL_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Info, 3, format, args)

#define NN_DETAIL_SPL_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Warn, 0, format, args)
#define NN_DETAIL_SPL_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Warn, 1, format, args)
#define NN_DETAIL_SPL_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Warn, 2, format, args)
#define NN_DETAIL_SPL_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Warn, 3, format, args)

#define NN_DETAIL_SPL_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Error, 0, format, args)
#define NN_DETAIL_SPL_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Error, 1, format, args)
#define NN_DETAIL_SPL_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Error, 2, format, args)
#define NN_DETAIL_SPL_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Error, 3, format, args)

#define NN_DETAIL_SPL_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Fatal, 0, format, args)
#define NN_DETAIL_SPL_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Fatal, 1, format, args)
#define NN_DETAIL_SPL_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Fatal, 2, format, args)
#define NN_DETAIL_SPL_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(spl, Fatal, 3, format, args)

#define NN_DETAIL_SPL_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(spl, Trace, 0, text, length)
#define NN_DETAIL_SPL_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Trace, 1, text, length)
#define NN_DETAIL_SPL_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Trace, 2, text, length)
#define NN_DETAIL_SPL_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Trace, 3, text, length)

#define NN_DETAIL_SPL_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(spl, Info, 0, text, length)
#define NN_DETAIL_SPL_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Info, 1, text, length)
#define NN_DETAIL_SPL_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Info, 2, text, length)
#define NN_DETAIL_SPL_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Info, 3, text, length)

#define NN_DETAIL_SPL_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(spl, Warn, 0, text, length)
#define NN_DETAIL_SPL_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Warn, 1, text, length)
#define NN_DETAIL_SPL_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Warn, 2, text, length)
#define NN_DETAIL_SPL_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(spl, Warn, 3, text, length)

#define NN_DETAIL_SPL_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(spl, Error, 0, text, length)
#define NN_DETAIL_SPL_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Error, 1, text, length)
#define NN_DETAIL_SPL_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Error, 2, text, length)
#define NN_DETAIL_SPL_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Error, 3, text, length)

#define NN_DETAIL_SPL_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(spl, Fatal, 0, text, length)
#define NN_DETAIL_SPL_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Fatal, 1, text, length)
#define NN_DETAIL_SPL_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Fatal, 2, text, length)
#define NN_DETAIL_SPL_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(spl, Fatal, 3, text, length)
