﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/spl/detail/spl_InternalTypes.h>
#include <nn/spl/spl_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace spl { namespace detail { // NOLINT(whitespace/braces)

class IFsInterface;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IFsInterface, (::nn::spl::detail::ICryptoInterface))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IFsInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreGcKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DecryptGcMessage, (::nn::sf::Out<::std::int32_t> resultSize, const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GenerateSpecificAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 purpose))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetPackage2Hash, (const ::nn::sf::OutArray<::nn::Bit8>& result))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IFsInterface)

        ::nn::Result DecryptAndStoreGcKey(const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecryptAndStoreGcKey, (data, accessKey, keySource));
        }

        ::nn::Result DecryptGcMessage(::nn::sf::Out<::std::int32_t> resultSize, const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DecryptGcMessage, (resultSize, result, cipher, modulus, labelDigest));
        }

        ::nn::Result GenerateSpecificAesKey(::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 purpose) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GenerateSpecificAesKey, (key, keySource, generation, purpose));
        }

        ::nn::Result LoadPreparedAesKey(::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (slotIndex, accessKey));
        }

        ::nn::Result GetPackage2Hash(const ::nn::sf::OutArray<::nn::Bit8>& result) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetPackage2Hash, (result));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IFsInterface : public ::nn::spl::detail::ICryptoInterface
    {
    public:
        nn::Result DecryptAndStoreGcKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
        nn::Result DecryptGcMessage(nn::sf::Out<std::int32_t> resultSize, const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest) NN_NOEXCEPT;
        nn::Result GenerateSpecificAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 purpose) NN_NOEXCEPT;
        nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
        nn::Result GetPackage2Hash(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetConfig(nn::sf::Out<nn::Bit64> pOut, std::int32_t key) NN_NOEXCEPT;
    nn::Result ModularExponentiate(const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& baseValue, const nn::sf::InArray<nn::Bit8>& exponent, const nn::sf::InArray<nn::Bit8>& modulus) NN_NOEXCEPT;
    nn::Result GenerateAesKek(nn::sf::Out<nn::spl::AccessKey> accessKey, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result LoadAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result GenerateAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result SetConfig(std::int32_t key, nn::Bit64 value) NN_NOEXCEPT;
    nn::Result GenerateRandomBytes(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
    nn::Result DecryptAndStoreGcKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT;
    nn::Result DecryptGcMessage(nn::sf::Out<std::int32_t> resultSize, const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest) NN_NOEXCEPT;
    nn::Result IsDevelopment(nn::sf::Out<bool> isDevelopment) NN_NOEXCEPT;
    nn::Result GenerateSpecificAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 purpose) NN_NOEXCEPT;
    nn::Result DecryptAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 option) NN_NOEXCEPT;
    nn::Result ComputeCtr(const nn::sf::OutBuffer& outBuffer, std::int32_t slotIndex, const nn::sf::InBuffer& inBuffer, const nn::spl::detail::IvIc& initialCounter) NN_NOEXCEPT;
    nn::Result ComputeCmac(nn::sf::Out<nn::spl::detail::Cmac> pOut, std::int32_t slotIndex, const nn::sf::InArray<nn::Bit8>& data) NN_NOEXCEPT;
    nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT;
    nn::Result AllocateAesKeySlot(nn::sf::Out<std::int32_t> slotIndex) NN_NOEXCEPT;
    nn::Result DeallocateAesKeySlot(std::int32_t slotIndex) NN_NOEXCEPT;
    nn::Result GetAesKeySlotAvailableEvent(nn::sf::Out<nn::sf::NativeHandle> handle) NN_NOEXCEPT;
    nn::Result SetBootReason(nn::spl::BootReasonValue bootReason) NN_NOEXCEPT;
    nn::Result GetBootReason(nn::sf::Out<nn::spl::BootReasonValue> bootReason) NN_NOEXCEPT;
    nn::Result GetPackage2Hash(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_WITH_BASE((::nn::spl::detail::IFsInterface), (::nn::spl::detail::ICryptoInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreGcKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecryptAndStoreGcKey, (data, accessKey, keySource));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptGcMessage, (::nn::sf::Out<::std::int32_t> resultSize, const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DecryptGcMessage, (resultSize, result, cipher, modulus, labelDigest));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateSpecificAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 purpose))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GenerateSpecificAesKey, (key, keySource, generation, purpose));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(LoadPreparedAesKey, (slotIndex, accessKey));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPackage2Hash, (const ::nn::sf::OutArray<::nn::Bit8>& result))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetPackage2Hash, (result));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::spl::detail::IFsInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_WITH_BASE((::nn::spl::detail::IFsInterface), (::nn::spl::detail::ICryptoInterface))

    // nn::Result DecryptAndStoreGcKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecryptAndStoreGcKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(data, 0, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (data))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, keySource))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(data), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecryptAndStoreGcKey)

    // nn::Result DecryptGcMessage(nn::sf::Out<std::int32_t> resultSize, const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DecryptGcMessage)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(cipher, 1, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(modulus, 2, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(labelDigest, 3, (const ::nn::sf::InArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (result, cipher, modulus, labelDigest))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(resultSize, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (resultSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(resultSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cipher), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(modulus), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(labelDigest)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DecryptGcMessage)

    // nn::Result GenerateSpecificAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 purpose) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GenerateSpecificAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(keySource, (::nn::spl::detail::KeySource), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(generation, (::std::int32_t), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(purpose, (::nn::Bit32), 20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (keySource, generation, purpose))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(key, (::nn::spl::detail::AesKey), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (key))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(keySource), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(generation), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(purpose)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GenerateSpecificAesKey)

    // nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(LoadPreparedAesKey)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(accessKey, (::nn::spl::AccessKey), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(slotIndex, (::std::int32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (accessKey, slotIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(slotIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(accessKey)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(LoadPreparedAesKey)

    // nn::Result GetPackage2Hash(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetPackage2Hash)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(result, 0, (const ::nn::sf::OutArray<::nn::Bit8>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (result))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(result)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetPackage2Hash)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::AccessKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::KeySource), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::AesKey), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::IvIc), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::detail::Cmac), 16, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::spl::BootReasonValue), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::spl::detail::IFsInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_WITH_BASE((::nn::spl::detail::IFsInterface), (::nn::spl::detail::ICryptoInterface))

    // nn::Result DecryptAndStoreGcKey(const nn::sf::InArray<nn::Bit8>& data, const nn::spl::AccessKey& accessKey, const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptAndStoreGcKey, (const ::nn::sf::InArray<::nn::Bit8>& data, const ::nn::spl::AccessKey& accessKey, const ::nn::spl::detail::KeySource& keySource))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecryptAndStoreGcKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(data)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecryptAndStoreGcKey)
    }

    // nn::Result DecryptGcMessage(nn::sf::Out<std::int32_t> resultSize, const nn::sf::OutArray<nn::Bit8>& result, const nn::sf::InArray<nn::Bit8>& cipher, const nn::sf::InArray<nn::Bit8>& modulus, const nn::sf::InArray<nn::Bit8>& labelDigest) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DecryptGcMessage, (::nn::sf::Out<::std::int32_t> resultSize, const ::nn::sf::OutArray<::nn::Bit8>& result, const ::nn::sf::InArray<::nn::Bit8>& cipher, const ::nn::sf::InArray<::nn::Bit8>& modulus, const ::nn::sf::InArray<::nn::Bit8>& labelDigest))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DecryptGcMessage)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(resultSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cipher)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(modulus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(labelDigest)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DecryptGcMessage)
    }

    // nn::Result GenerateSpecificAesKey(nn::sf::Out<nn::spl::detail::AesKey> key, const nn::spl::detail::KeySource& keySource, std::int32_t generation, nn::Bit32 purpose) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GenerateSpecificAesKey, (::nn::sf::Out<::nn::spl::detail::AesKey> key, const ::nn::spl::detail::KeySource& keySource, ::std::int32_t generation, ::nn::Bit32 purpose))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GenerateSpecificAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(keySource)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(generation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(purpose)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GenerateSpecificAesKey)
    }

    // nn::Result LoadPreparedAesKey(std::int32_t slotIndex, const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(LoadPreparedAesKey, (::std::int32_t slotIndex, const ::nn::spl::AccessKey& accessKey))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(LoadPreparedAesKey)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(slotIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(accessKey)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(LoadPreparedAesKey)
    }

    // nn::Result GetPackage2Hash(const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetPackage2Hash, (const ::nn::sf::OutArray<::nn::Bit8>& result))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetPackage2Hash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(result)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetPackage2Hash)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::spl::detail::IFsInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_WITH_BASE((::nn::spl::detail::IFsInterface), (::nn::spl::detail::ICryptoInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecryptAndStoreGcKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(data)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecryptAndStoreGcKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(data),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DecryptGcMessage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(cipher)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(modulus)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(labelDigest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DecryptGcMessage)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(resultSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(cipher),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(modulus),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(labelDigest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GenerateSpecificAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GenerateSpecificAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(keySource),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(generation),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(purpose)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(LoadPreparedAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(LoadPreparedAesKey)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(slotIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(accessKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetPackage2Hash)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(result)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetPackage2Hash)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(result)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecryptAndStoreGcKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DecryptGcMessage)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GenerateSpecificAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(LoadPreparedAesKey)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetPackage2Hash)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END_WITH_BASE

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::spl::detail::IFsInterface))
