﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
    @file
    @brief  Private header with all the socket definitions and function
            declarations that will soon be deprecated.
 */

#pragma once


/**
    @namespace nn::socket
*/
namespace nn     {
namespace socket {

/**
    @brief          Opens a socket that is exempt from SocketShutdownAll - This API will be deprecated in an upcoming SDK release.

    @param[in]      domain          Communication domain
    @param[in]      type            Socket type
    @param[in]      protocol        Protocol type

    @return         Returns non-negative socket descriptor or -1 if error occurred.

    @details        Opens a socket that is exempt from SocketShutdownAll(), unless the forced option is true for SocketShutdownAll().
                    This option can also by setting the socket option SO_NN_SHUTDOWN_EXEMPT to non-zero using SetSockOpt().
                    Using SocketExempt is recommended over the SetSockOpt alternative due to possible race-conditions of being shutdown between
                    socket creation and setting of the SO_NN_SHUTDOWN_EXEMPT option.

    @note           This function will soon be deprecated. Please use
                    @ref SocketExempt(nn::socket::Family, nn::socket::Type, nn::socket::Protocol).

    @see            SocketExempt(nn::socket::Family, nn::socket::Type, nn::socket::Protocol)
*/
int SocketExempt(int domain, int type, int protocol) NN_NOEXCEPT;

/**
    @brief          Look up AF_INET host IP address by hostname - This API will be deprecated in an upcoming SDK release.

    @param[in]      pName           The name of the host to look up (i.e. www.nintendo.com)
    @param[in]      options         An array of ResolverOption that contain the cancel handle and / or NSD
    @param[in]      optionsCount    the number of ResolverOption structures in the array

    @return         Returns a struct hostent or NULL on error with error detail in GetHErrno.

    @details        The return value of this function is thread-localized, this deviates from some POSIX implementations.
                    The return value is managed internally, if you wish to maintain the value between calls a deep copy must be made.

    @note           This function will soon be deprecated. Please use
                    @ref GetHostEntByName(const char*, const nn::socket::ResolverOption*, size_t).

    @see            GetHostEntByName(const char*, const nn::socket::ResolverOption*, size_t)
*/
hostent* GetHostByName(const char* pName, const nn::socket::ResolverOption* options, size_t optionsCount) NN_NOEXCEPT;

/**
    @brief          Get a list of IP addresses and port numbers - This API will be deprecated in an upcoming SDK release.

    @param[in]      pNodeName the name of the host or NULL.
    @param[in]      pServername the name of the service or NULL.
    @param[in]      pHints is an optional pointer to a struct addrinfo as defined by netdb.h.
    @param[out]     pResult an out parameter containing 0, 1, or many (via ai_next) addrinfo structures.
    @param[in]      options         An array of ResolverOption that contain the cancel handle and / or NSD
    @param[in]      optionsCount    the number of ResolverOption structures in the array

    @return         Returns one of the following values:
    @return         NETDB_INTERNAL see @ref GetLastErrno()
    @return         NETDB_SUCCESS no problem
    @return         HOST_NOT_FOUND Authoritative Answer Host not found
    @return         TRY_AGAIN Non-Authoritative Host not found, or SERVERFAIL
    @return         NO_RECOVERY Non recoverable errors, FORMERR, REFUSED, NOTIMP
    @return         NO_DATA Valid name, no data record of requested type
    @return         NO_ADDRESS no address, look for MX record

    @details        GetAddrInfo() routine can be used to obtain list of IP addresses and port numbers for
                    host @a pNodename and service @a pServername. It provides more flexibility than @ref GetHostByName().

                    Please note that @a pNodename and @a pServername cannot both be NULL at the same time.

                    The addrinfo result @a pResult returned by this function can be deallocated via @ref FreeAddrInfo().

                    The optional pHint can be used to provide hints concerning the type of socket
                    that the caller supports or wishes to use. The caller can supply the
                    following structure elements in hints:

                    ai_family       The protocol family that should be used.  When ai_family
                                    is set to PF_UNSPEC, it means the caller will accept any
                                    protocol family supported by the operating system.

                    ai_socktype     Denotes the type of socket that is wanted: SOCK_STREAM,
                                    SOCK_DGRAM, or SOCK_RAW.  When ai_socktype is zero the
                                    caller will accept any socket type.

                    ai_protocol     Indicates which transport protocol is desired, IPPROTO_UDP
                                    or IPPROTO_TCP.  If ai_protocol is zero the caller will
                                    accept any protocol.

                    ai_flags        The ai_flags field to which the hints parameter points
                                    shall be set to zero or be the bitwise-inclusive OR of one
                                    or more of the values AI_ADDRCONFIG, AI_CANONNAME,
                                    AI_NUMERICHOST, AI_NUMERICSERV and AI_PASSIVE.

                    AI_ADDRCONFIG   If the AI_ADDRCONFIG bit is set, IPv4
                                    addresses shall be returned only if an
                                    IPv4 address is configured on the local
                                    system, and IPv6 addresses shall be
                                    returned only if an IPv6 address is configured on the local system.

                    AI_CANONNAME    If the AI_CANONNAME bit is set, a successful
                                    call to @ref GetAddrInfo() will return a
                                    NUL-terminated string containing the
                                    canonical name of the specified hostname
                                    in the ai_canonname element of the first
                                    addrinfo structure returned.

                    AI_NUMERICHOST  If the AI_NUMERICHOST bit is set, it indicates
                                    that hostname should be treated as a
                                    numeric string defining an IPv4 or IPv6
                                    address and resolution should be
                                    attempted.

                    AI_NUMERICSERV  If the AI_NUMERICSERV bit is set, then a
                                    non-null servname string supplied shall be
                                    a numeric port string.  Otherwise, an
                                    EAI_NONAME error shall be returned. This
                                    bit shall prevent any type of name resolution
                                    service (for example, NIS+) from
                                    being invoked.

                    AI_PASSIVE      If the AI_PASSIVE bit is set it indicates
                                    that the returned socket address structure
                                    is intended for use in a call to bind(2).
                                    In this case, if the hostname argument is
                                    the null pointer, then the IP address portion
                                    of the socket address structure will
                                    be set to INADDR_ANY for an IPv4 address
                                    or IN6ADDR_ANY_INIT for an IPv6 address.

                                    If the AI_PASSIVE bit is not set, the
                                    returned socket address structure will be
                                    ready for use in a call to Connect() for
                                    a connection-oriented protocol or
                                    Connect(), SendTo(), or SendMsg() if a
                                    connectionless protocol was chosen.  The
                                    IP address portion of the socket address
                                    structure will be set to the loopback
                                    address if hostname is the null pointer
                                    and AI_PASSIVE is not set.

                    All other elements of the addrinfo structure passed via hints must be
                    zero or the null pointer.

                    If hints is the null pointer, getaddrinfo() behaves as if the caller provided
                    a struct addrinfo with ai_family set to PF_UNSPEC and all other
                    elements set to zero or NULL.

    @note           This function will soon be deprecated. Please use
                    @ref GetAddrInfo(const char*, const char*, const nn::socket::AddrInfo*, nn::socket::AddrInfo**, const nn::socket::ResolverOption*, size_t).

    @see            GetAddrInfo(const char*, const char*, const nn::socket::AddrInfo*, nn::socket::AddrInfo**, const nn::socket::ResolverOption*, size_t)
*/
int GetAddrInfo(const char* pNodeName, const char* pServername, const addrinfo* pHints, addrinfo** pResult, const nn::socket::ResolverOption* options, size_t optionsCount) NN_NOEXCEPT;

/**
    @brief          Convert a sockaddr structure to a pair of host name and service strings - This API will be deprecated in an upcoming SDK release.

    @param[in]      socketAddress       The sockaddr structure sa should point to a sockaddr_in thatis socketAddressLength bytes long.
                                        Note: sockaddr_in6 / sockaddr_dl are not currently supported.
    @param[in]      socketAddressLength The size of the socckaddr structure.
    @param[out]     host                The hostname buffer.
    @param[in]      hostLength          The length of the hostname buffer.
    @param[out]     service             The service name buffer.
    @param[in]      serviceLength       The length of the service name buffer.
    @param[in]      flags               Flags.
    @param[in]      options             An array of ResolverOption that contain the cancel handle and / or NSD.
    @param[in]      optionsCount        The number of ResolverOption structures in the array.

    @return         Returns one of the following values:
    @return         NETDB_INTERNAL      see @ref GetLastErrno().
    @return         NETDB_SUCCESS       No problem.
    @return         HOST_NOT_FOUND      Authoritative Answer Host not found.
    @return         TRY_AGAIN           Non-Authoritative Host not found, or SERVERFAIL.
    @return         NO_RECOVERY         Non recoverable errors, FORMERR, REFUSED, NOTIMP.
    @return         NO_DATA             Valid name, no data record of requested type.
    @return         NO_ADDRESS          No address, look for MX record.

    @details        The GetNameInfo() function is used to convert a sockaddr structure to a pair of host name and service strings.
                    It provides more flexibility than the @ref GetHostByAddr(). The addrinfo result @a pResult
                    returned by this function can be deallocated via @ref FreeAddrInfo().

                    @a flags argument is formed by OR'ing the following values from netdb.h:

                    NI_NOFQDN           A fully qualified domain name is not required for local
                                        hosts.  The local part of the fully qualified domain
                                        name is returned instead.

                    NI_NUMERICHOST      Return the address in numeric form, as if calling
                                        @ref InetNtop(), instead of a host name.

                    NI_NAMEREQD         A name is required.  If the host name cannot be found
                                        in DNS and this flag is set, a non-zero error code is
                                        returned.  If the host name is not found and the flag
                                        is not set, the address is returned in numeric form.

                    NI_NUMERICSERV      The service name is returned as a digit string repre-
                                        senting the port number.

                    NI_DGRAM            Specifies that the service being looked up is a datagram
                                        service.

    @note           This function will soon be deprecated. Please use
                    @ref GetNameInfo(const nn::socket::SockAddr*, nn::socket::SockLenT, char*, size_t, char*, size_t, nn::socket::NameInfoFlag, const nn::socket::ResolverOption*, size_t).

    @see            GetNameInfo(const nn::socket::SockAddr*, nn::socket::SockLenT, char*, size_t, char*, size_t, nn::socket::NameInfoFlag, const nn::socket::ResolverOption*, size_t)
*/
int GetNameInfo(const sockaddr* socketAddress, socklen_t socketAddressLength, char* host, socklen_t hostLength, char* service, socklen_t serviceLength, int flags, const nn::socket::ResolverOption* options, size_t optionsCount) NN_NOEXCEPT;

/**
    @brief          Look up the address value for a host for AF_INET - This API will be deprecated in an upcoming SDK release.

    @param[in]      pAddress        This value shall be an in_addr structure that contains a binary address in network byte order.
    @param[in]      length          The size of the structure.
    @param[in]      addressFamily   Currently only AF_INET is supported
    @param[in]      options         An array of ResolverOption that contain the cancel handle and / or NSD
    @param[in]      optionsCount    the number of ResolverOption structures in the array

    @return         Returns a struct hostent or NULL on error with error detail in GetHErrno.

    @details        The return value of this function is thread-localized, this deviates from some POSIX implementations.
                    The return value is managed internally, if you wish to maintain the value between calls a deep copy must be made.

    @note           This function will soon be deprecated. Please use
                    @ref GetHostEntByAddr(const void*, nn::socket::SockLenT, nn::socket::Family, const nn::socket::ResolverOption*, size_t).

    @see            GetHostEntByAddr(const void*, nn::socket::SockLenT, nn::socket::Family, const nn::socket::ResolverOption*, size_t)
*/
hostent* GetHostByAddr(const void* pAddress, socklen_t length, int addressFamily, const nn::socket::ResolverOption* options, size_t optionsCount) NN_NOEXCEPT;

/**
    @brief          Receive multiple messages on a socket - This API will be deprecated in an upcoming SDK release.

    @param[in]      socket      The file descriptor of the socket to receive data from.
    @param[in]      pMsgvec     A pointer to an array of mmsghdr structures.
    @param[in]      vlen        The length of the array specified by pMsgvec.
    @param[in]      flags       The flags argument contains flags ORed together.
    @param[in]      pTimeout    Points to a nn::TimeSpan object defining a timeout
                                for the receive operation.

    @return         On success, RecvMMsg() returns the number of messages received in @a pMsgvec.

                    On error, -1 is returned, and errno is set to indicate the error. In the case
                    of an error occurring after at least one message has been received,
                    RecvMMsg() will return the number of messages received.

    @details        The RecvMMsg() system call is an extension of @ref RecvMsg() that allows the caller
                    to receive multiple messages from a socket using a single system call.
                    (This can result in a drastic reduction in CPU usage.)

                    A further extension over @ref RecvMsg() is support for a timeout on the
                    receive operation.

                    The @a sockfd argument is the file descriptor of the socket to receive
                    data from.

                    The @a pMsgvec argument is a pointer to an array of mmsghdr structures.
                    The size of this array is specified in @a vlen.

                    The @a msg_hdr field is a msghdr structure, as described in @ref RecvMsg().
                    The @a msg_len field is the number of bytes returned for the message in
                    the entry. This field has the same value as the return value of a
                    single @ref RecvMsg() on the header.

                    The @a pTimeout argument points to a struct timespec defining a timeout
                    (seconds plus nanoseconds) for the receive operation.
                    If @a pTimeout is NULL, then the operation blocks indefinitely.

                    A blocking @ref RecvMMsg() call blocks until @a vlen messages have been
                    received or until the timeout expires. A nonblocking call reads as
                    many messages as are available (up to the limit specified by @a vlen)
                    and returns immediately.

                    On return from RecvMMsg(), successive elements of @a pMsgvec are updated
                    to contain information about each received message: @a msg_len contains
                    the size of the received message; the subfields of @a msg_hdr are
                    updated as described in @ref RecvMsg(). The return value of the call
                    indicates the number of elements of @a pMsgvec that have been updated.

    @note           This function will soon be deprecated. Please use
                    @ref RecvMMsg(int, nn::socket::MMsgHdr*, size_t, nn::socket::MsgFlag, nn::TimeSpan *pTimeout).

    @see            RecvMMsg(int, nn::socket::MMsgHdr*, size_t, nn::socket::MsgFlag, nn::TimeSpan *pTimeout)
*/
ssize_t RecvMMsg(int socket, struct mmsghdr* pMsgvec, size_t vlen, int flags, nn::TimeSpan *pTimeout) NN_NOEXCEPT;

/**
    @brief          Send multiple messages on a socket - This API will be deprecated in an upcoming SDK release.

    @param[in]      socket      The file descriptor of the socket on which data is to be transmitted.
    @param[in]      msgvec      A pointer to an array of mmsghdr structures.
    @param[in]      vlen        The length of the array specified by msgvec.
    @param[in]      flags       The flags argument contains flags ORed together.

    @return         On success, SendMMsg() returns the number of messages sent from msgvec.
                    If this is less than vlen, the caller can retry with a further SendMMsg()
                    call to send the remaining messages.

                    On error, -1 is returned, and errno is set to indicate the error. In the case
                    of an error occurring after at least one message has been sent,
                    SendMMsg() will return the number of messages sent.

    @details        The SendMMsg() system call is an extension of @ref SendMsg() that allows the caller
                    to transmit multiple messages on a socket using a single system call.
                    (This can result in a drastic reduction in CPU usage.)

                   The @a sockfd argument is the file descriptor of the socket on which
                   data is to be transmitted.

                   The @a msgvec argument is a pointer to an array of mmsghdr structures.
                   The size of this array is specified in vlen.

                   The @a msg_hdr field is a msghdr structure, as described in @ref SendMsg().
                   The @a msg_len field is used to return the number of bytes sent from the
                   message in @a msg_hdr (i.e., the same as the return value from a single
                   @ref SendMsg() call).

                   The @a flags argument contains flags ORed together. The flags are the
                   same as for @ref SendMsg().

                   A blocking SendMMsg() call blocks until @a vlen messages have been sent.
                   A nonblocking call sends as many messages as possible (up to the
                   limit specified by @a vlen) and returns immediately.

                   On return from SendMMsg(), the @a msg_len fields of successive elements
                   of @a msgvec are updated to contain the number of bytes transmitted from
                   the corresponding @a msg_hdr. The return value of the call indicates
                   the number of elements of @a msgvec that have been updated.

    @note           This function will soon be deprecated. Please use
                    @ref SendMMsg(int, const nn::socket::MMsgHdr*, size_t, nn::socket::MsgFlag).

    @see            SendMMsg(int, const nn::socket::MMsgHdr*, size_t, nn::socket::MsgFlag)
*/
ssize_t SendMMsg(int socket, const struct mmsghdr* msgvec, size_t vlen, int flags) NN_NOEXCEPT;

}} /* nn::socket */
