﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace socket { namespace resolver { // NOLINT(whitespace/braces)

class IResolver;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IResolver, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IResolver)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetDnsAddressesPrivateRequest, (const ::nn::sf::InBuffer& sockaddrArray, ::std::uint32_t length))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDnsAddressPrivateRequest, (::std::uint32_t n, const ::nn::sf::OutBuffer& socketAddressOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& name, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& serializedInAddrIn, ::std::uint32_t serializedInAddrLengthIn, ::std::uint32_t addressFamilyIn, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHostStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetGaiStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& serializedNodeNameIn, const ::nn::sf::InBuffer& serializedServiceNameIn, const ::nn::sf::InBuffer& serializedAddrInfoHintsIn, const ::nn::sf::OutBuffer& addrInfoArrayOut, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& socketAddressPointerIn, const ::nn::sf::OutBuffer& hostBufferOut, const ::nn::sf::OutBuffer& serviceBufferOut, ::std::uint32_t flagsIn, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetCancelHandleRequest, (::nn::Bit64 pid, ::nn::sf::Out<::std::uint32_t> RequestHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelRequest, (::nn::Bit64 pid, ::std::uint32_t RequestHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nameParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& inAddrParam, ::std::uint32_t inAddrLengthParam, ::std::int32_t addressFamilyParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nodeNameParam, const ::nn::sf::InBuffer& serviceNameParam, const ::nn::sf::InBuffer& serializedHintsParam, const ::nn::sf::OutBuffer& serializedAddrinfoResultBuffer, ::nn::sf::Out<::std::uint32_t> pSerializedAddrinfoResultBufferSize, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& socketAddressParamPointerIn, const ::nn::sf::OutBuffer& hostBufferOutParam, const ::nn::sf::OutBuffer& serviceBufferOutParam, ::std::uint32_t flagsParam, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolverSetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResolverGetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t key, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, const ::nn::sf::OutBuffer& serializedOptionBufferOut, ::nn::sf::Out<::std::uint32_t> outBufferUsed, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IResolver)

        ::nn::Result SetDnsAddressesPrivateRequest(const ::nn::sf::InBuffer& sockaddrArray, ::std::uint32_t length) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetDnsAddressesPrivateRequest, (sockaddrArray, length));
        }

        ::nn::Result GetDnsAddressPrivateRequest(::std::uint32_t n, const ::nn::sf::OutBuffer& socketAddressOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDnsAddressPrivateRequest, (n, socketAddressOut));
        }

        ::nn::Result GetHostByNameRequest(::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& name, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHostByNameRequest, (cancelHandle, pid, useNsdResolve, name, hostErrorOut, errnoOut, serializedHostentResponse, bufferLengthOut));
        }

        ::nn::Result GetHostByAddrRequest(::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& serializedInAddrIn, ::std::uint32_t serializedInAddrLengthIn, ::std::uint32_t addressFamilyIn, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHostByAddrRequest, (cancelHandle, pid, serializedInAddrIn, serializedInAddrLengthIn, addressFamilyIn, hostErrorOut, errnoOut, serializedHostentResponse, bufferLengthOut));
        }

        ::nn::Result GetHostStringErrorRequest(::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHostStringErrorRequest, (errorRequestIn, stringErrorResponse));
        }

        ::nn::Result GetGaiStringErrorRequest(::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetGaiStringErrorRequest, (errorRequestIn, stringErrorResponse));
        }

        ::nn::Result GetAddrInfoRequest(::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& serializedNodeNameIn, const ::nn::sf::InBuffer& serializedServiceNameIn, const ::nn::sf::InBuffer& serializedAddrInfoHintsIn, const ::nn::sf::OutBuffer& addrInfoArrayOut, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut, ::nn::sf::Out<::std::uint32_t> bufferLengthOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAddrInfoRequest, (cancelHandle, pid, useNsdResolve, serializedNodeNameIn, serializedServiceNameIn, serializedAddrInfoHintsIn, addrInfoArrayOut, errnoOut, returnValueOut, bufferLengthOut));
        }

        ::nn::Result GetNameInfoRequest(::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& socketAddressPointerIn, const ::nn::sf::OutBuffer& hostBufferOut, const ::nn::sf::OutBuffer& serviceBufferOut, ::std::uint32_t flagsIn, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNameInfoRequest, (cancelHandle, pid, socketAddressPointerIn, hostBufferOut, serviceBufferOut, flagsIn, errnoOut, returnValueOut));
        }

        ::nn::Result GetCancelHandleRequest(::nn::Bit64 pid, ::nn::sf::Out<::std::uint32_t> RequestHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetCancelHandleRequest, (pid, RequestHandle));
        }

        ::nn::Result CancelRequest(::nn::Bit64 pid, ::std::uint32_t RequestHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelRequest, (pid, RequestHandle));
        }

        ::nn::Result GetHostByNameRequestWithOptions(::nn::Bit64 processId, const ::nn::sf::InBuffer& nameParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHostByNameRequestWithOptions, (processId, nameParam, serializedHostEntryOut, pSerializedHostEntrySizeOut, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
        }

        ::nn::Result GetHostByAddrRequestWithOptions(::nn::Bit64 processId, const ::nn::sf::InBuffer& inAddrParam, ::std::uint32_t inAddrLengthParam, ::std::int32_t addressFamilyParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetHostByAddrRequestWithOptions, (processId, inAddrParam, inAddrLengthParam, addressFamilyParam, serializedHostEntryOut, pSerializedHostEntrySizeOut, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
        }

        ::nn::Result GetAddrInfoRequestWithOptions(::nn::Bit64 processId, const ::nn::sf::InBuffer& nodeNameParam, const ::nn::sf::InBuffer& serviceNameParam, const ::nn::sf::InBuffer& serializedHintsParam, const ::nn::sf::OutBuffer& serializedAddrinfoResultBuffer, ::nn::sf::Out<::std::uint32_t> pSerializedAddrinfoResultBufferSize, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAddrInfoRequestWithOptions, (processId, nodeNameParam, serviceNameParam, serializedHintsParam, serializedAddrinfoResultBuffer, pSerializedAddrinfoResultBufferSize, pReturnCode, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
        }

        ::nn::Result GetNameInfoRequestWithOptions(::nn::Bit64 processId, const ::nn::sf::InBuffer& socketAddressParamPointerIn, const ::nn::sf::OutBuffer& hostBufferOutParam, const ::nn::sf::OutBuffer& serviceBufferOutParam, ::std::uint32_t flagsParam, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetNameInfoRequestWithOptions, (processId, socketAddressParamPointerIn, hostBufferOutParam, serviceBufferOutParam, flagsParam, pReturnCode, version, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
        }

        ::nn::Result ResolverSetOptionRequest(::nn::Bit64 processId, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolverSetOptionRequest, (processId, version, serializedOption, pReturnCode, pOutErrno));
        }

        ::nn::Result ResolverGetOptionRequest(::nn::Bit64 processId, ::std::uint32_t key, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, const ::nn::sf::OutBuffer& serializedOptionBufferOut, ::nn::sf::Out<::std::uint32_t> outBufferUsed, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResolverGetOptionRequest, (processId, key, version, serializedOption, serializedOptionBufferOut, outBufferUsed, pReturnCode, pOutErrno));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IResolver
    {
    public:
        nn::Result SetDnsAddressesPrivateRequest(const nn::sf::InBuffer& sockaddrArray, std::uint32_t length) NN_NOEXCEPT;
        nn::Result GetDnsAddressPrivateRequest(std::uint32_t n, const nn::sf::OutBuffer& socketAddressOut) NN_NOEXCEPT;
        nn::Result GetHostByNameRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& name, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
        nn::Result GetHostByAddrRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& serializedInAddrIn, std::uint32_t serializedInAddrLengthIn, std::uint32_t addressFamilyIn, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
        nn::Result GetHostStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT;
        nn::Result GetGaiStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT;
        nn::Result GetAddrInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& serializedNodeNameIn, const nn::sf::InBuffer& serializedServiceNameIn, const nn::sf::InBuffer& serializedAddrInfoHintsIn, const nn::sf::OutBuffer& addrInfoArrayOut, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
        nn::Result GetNameInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& socketAddressPointerIn, const nn::sf::OutBuffer& hostBufferOut, const nn::sf::OutBuffer& serviceBufferOut, std::uint32_t flagsIn, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut) NN_NOEXCEPT;
        nn::Result GetCancelHandleRequest(nn::Bit64 pid, nn::sf::Out<std::uint32_t> RequestHandle) NN_NOEXCEPT;
        nn::Result CancelRequest(nn::Bit64 pid, std::uint32_t RequestHandle) NN_NOEXCEPT;
        nn::Result GetHostByNameRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nameParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
        nn::Result GetHostByAddrRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& inAddrParam, std::uint32_t inAddrLengthParam, std::int32_t addressFamilyParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
        nn::Result GetAddrInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nodeNameParam, const nn::sf::InBuffer& serviceNameParam, const nn::sf::InBuffer& serializedHintsParam, const nn::sf::OutBuffer& serializedAddrinfoResultBuffer, nn::sf::Out<std::uint32_t> pSerializedAddrinfoResultBufferSize, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
        nn::Result GetNameInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& socketAddressParamPointerIn, const nn::sf::OutBuffer& hostBufferOutParam, const nn::sf::OutBuffer& serviceBufferOutParam, std::uint32_t flagsParam, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t version, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
        nn::Result ResolverSetOptionRequest(nn::Bit64 processId, std::uint32_t version, const nn::sf::InBuffer& serializedOption, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
        nn::Result ResolverGetOptionRequest(nn::Bit64 processId, std::uint32_t key, std::uint32_t version, const nn::sf::InBuffer& serializedOption, const nn::sf::OutBuffer& serializedOptionBufferOut, nn::sf::Out<std::uint32_t> outBufferUsed, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result SetDnsAddressesPrivateRequest(const nn::sf::InBuffer& sockaddrArray, std::uint32_t length) NN_NOEXCEPT;
    nn::Result GetDnsAddressPrivateRequest(std::uint32_t n, const nn::sf::OutBuffer& socketAddressOut) NN_NOEXCEPT;
    nn::Result GetHostByNameRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& name, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
    nn::Result GetHostByAddrRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& serializedInAddrIn, std::uint32_t serializedInAddrLengthIn, std::uint32_t addressFamilyIn, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
    nn::Result GetHostStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT;
    nn::Result GetGaiStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT;
    nn::Result GetAddrInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& serializedNodeNameIn, const nn::sf::InBuffer& serializedServiceNameIn, const nn::sf::InBuffer& serializedAddrInfoHintsIn, const nn::sf::OutBuffer& addrInfoArrayOut, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT;
    nn::Result GetNameInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& socketAddressPointerIn, const nn::sf::OutBuffer& hostBufferOut, const nn::sf::OutBuffer& serviceBufferOut, std::uint32_t flagsIn, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut) NN_NOEXCEPT;
    nn::Result GetCancelHandleRequest(nn::Bit64 pid, nn::sf::Out<std::uint32_t> RequestHandle) NN_NOEXCEPT;
    nn::Result CancelRequest(nn::Bit64 pid, std::uint32_t RequestHandle) NN_NOEXCEPT;
    nn::Result GetHostByNameRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nameParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    nn::Result GetHostByAddrRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& inAddrParam, std::uint32_t inAddrLengthParam, std::int32_t addressFamilyParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    nn::Result GetAddrInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nodeNameParam, const nn::sf::InBuffer& serviceNameParam, const nn::sf::InBuffer& serializedHintsParam, const nn::sf::OutBuffer& serializedAddrinfoResultBuffer, nn::sf::Out<std::uint32_t> pSerializedAddrinfoResultBufferSize, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    nn::Result GetNameInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& socketAddressParamPointerIn, const nn::sf::OutBuffer& hostBufferOutParam, const nn::sf::OutBuffer& serviceBufferOutParam, std::uint32_t flagsParam, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t version, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    nn::Result ResolverSetOptionRequest(nn::Bit64 processId, std::uint32_t version, const nn::sf::InBuffer& serializedOption, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
    nn::Result ResolverGetOptionRequest(nn::Bit64 processId, std::uint32_t key, std::uint32_t version, const nn::sf::InBuffer& serializedOption, const nn::sf::OutBuffer& serializedOptionBufferOut, nn::sf::Out<std::uint32_t> outBufferUsed, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::socket::resolver::IResolver))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDnsAddressesPrivateRequest, (const ::nn::sf::InBuffer& sockaddrArray, ::std::uint32_t length))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetDnsAddressesPrivateRequest, (sockaddrArray, length));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDnsAddressPrivateRequest, (::std::uint32_t n, const ::nn::sf::OutBuffer& socketAddressOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDnsAddressPrivateRequest, (n, socketAddressOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& name, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHostByNameRequest, (cancelHandle, pid, useNsdResolve, name, hostErrorOut, errnoOut, serializedHostentResponse, bufferLengthOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& serializedInAddrIn, ::std::uint32_t serializedInAddrLengthIn, ::std::uint32_t addressFamilyIn, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHostByAddrRequest, (cancelHandle, pid, serializedInAddrIn, serializedInAddrLengthIn, addressFamilyIn, hostErrorOut, errnoOut, serializedHostentResponse, bufferLengthOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHostStringErrorRequest, (errorRequestIn, stringErrorResponse));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGaiStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetGaiStringErrorRequest, (errorRequestIn, stringErrorResponse));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& serializedNodeNameIn, const ::nn::sf::InBuffer& serializedServiceNameIn, const ::nn::sf::InBuffer& serializedAddrInfoHintsIn, const ::nn::sf::OutBuffer& addrInfoArrayOut, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAddrInfoRequest, (cancelHandle, pid, useNsdResolve, serializedNodeNameIn, serializedServiceNameIn, serializedAddrInfoHintsIn, addrInfoArrayOut, errnoOut, returnValueOut, bufferLengthOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& socketAddressPointerIn, const ::nn::sf::OutBuffer& hostBufferOut, const ::nn::sf::OutBuffer& serviceBufferOut, ::std::uint32_t flagsIn, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNameInfoRequest, (cancelHandle, pid, socketAddressPointerIn, hostBufferOut, serviceBufferOut, flagsIn, errnoOut, returnValueOut));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCancelHandleRequest, (::nn::Bit64 pid, ::nn::sf::Out<::std::uint32_t> RequestHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetCancelHandleRequest, (pid, RequestHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelRequest, (::nn::Bit64 pid, ::std::uint32_t RequestHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelRequest, (pid, RequestHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nameParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHostByNameRequestWithOptions, (processId, nameParam, serializedHostEntryOut, pSerializedHostEntrySizeOut, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& inAddrParam, ::std::uint32_t inAddrLengthParam, ::std::int32_t addressFamilyParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetHostByAddrRequestWithOptions, (processId, inAddrParam, inAddrLengthParam, addressFamilyParam, serializedHostEntryOut, pSerializedHostEntrySizeOut, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nodeNameParam, const ::nn::sf::InBuffer& serviceNameParam, const ::nn::sf::InBuffer& serializedHintsParam, const ::nn::sf::OutBuffer& serializedAddrinfoResultBuffer, ::nn::sf::Out<::std::uint32_t> pSerializedAddrinfoResultBufferSize, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAddrInfoRequestWithOptions, (processId, nodeNameParam, serviceNameParam, serializedHintsParam, serializedAddrinfoResultBuffer, pSerializedAddrinfoResultBufferSize, pReturnCode, optionsRequestVersion, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& socketAddressParamPointerIn, const ::nn::sf::OutBuffer& hostBufferOutParam, const ::nn::sf::OutBuffer& serviceBufferOutParam, ::std::uint32_t flagsParam, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetNameInfoRequestWithOptions, (processId, socketAddressParamPointerIn, hostBufferOutParam, serviceBufferOutParam, flagsParam, pReturnCode, version, serializedOptionsBuffer, optionsCountIn, pOutHostError, pOutErrno));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolverSetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolverSetOptionRequest, (processId, version, serializedOption, pReturnCode, pOutErrno));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolverGetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t key, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, const ::nn::sf::OutBuffer& serializedOptionBufferOut, ::nn::sf::Out<::std::uint32_t> outBufferUsed, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResolverGetOptionRequest, (processId, key, version, serializedOption, serializedOptionBufferOut, outBufferUsed, pReturnCode, pOutErrno));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::socket::resolver::IResolver>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::socket::resolver::IResolver))

    // nn::Result SetDnsAddressesPrivateRequest(const nn::sf::InBuffer& sockaddrArray, std::uint32_t length) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetDnsAddressesPrivateRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(sockaddrArray, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (sockaddrArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(length, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (length))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(sockaddrArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(length)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetDnsAddressesPrivateRequest)

    // nn::Result GetDnsAddressPrivateRequest(std::uint32_t n, const nn::sf::OutBuffer& socketAddressOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDnsAddressPrivateRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(socketAddressOut, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (socketAddressOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(n, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (n))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(n), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(socketAddressOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDnsAddressPrivateRequest)

    // nn::Result GetHostByNameRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& name, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostByNameRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(name, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedHostentResponse, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (name, serializedHostentResponse))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(useNsdResolve, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(cancelHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (useNsdResolve, cancelHandle, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hostErrorOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(errnoOut, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bufferLengthOut, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (hostErrorOut, errnoOut, bufferLengthOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cancelHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(useNsdResolve), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(name), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hostErrorOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errnoOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedHostentResponse), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferLengthOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostByNameRequest)

    // nn::Result GetHostByAddrRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& serializedInAddrIn, std::uint32_t serializedInAddrLengthIn, std::uint32_t addressFamilyIn, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostByAddrRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedInAddrIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedHostentResponse, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (serializedInAddrIn, serializedHostentResponse))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(cancelHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(serializedInAddrLengthIn, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addressFamilyIn, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (cancelHandle, serializedInAddrLengthIn, addressFamilyIn, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(hostErrorOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(errnoOut, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bufferLengthOut, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (hostErrorOut, errnoOut, bufferLengthOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cancelHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedInAddrIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedInAddrLengthIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addressFamilyIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hostErrorOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errnoOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedHostentResponse), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferLengthOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostByAddrRequest)

    // nn::Result GetHostStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostStringErrorRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringErrorResponse, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (stringErrorResponse))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(errorRequestIn, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (errorRequestIn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errorRequestIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringErrorResponse)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostStringErrorRequest)

    // nn::Result GetGaiStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetGaiStringErrorRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(stringErrorResponse, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (stringErrorResponse))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(errorRequestIn, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (errorRequestIn))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errorRequestIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stringErrorResponse)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetGaiStringErrorRequest)

    // nn::Result GetAddrInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& serializedNodeNameIn, const nn::sf::InBuffer& serializedServiceNameIn, const nn::sf::InBuffer& serializedAddrInfoHintsIn, const nn::sf::OutBuffer& addrInfoArrayOut, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAddrInfoRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedNodeNameIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedServiceNameIn, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedAddrInfoHintsIn, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(addrInfoArrayOut, 3, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (serializedNodeNameIn, serializedServiceNameIn, serializedAddrInfoHintsIn, addrInfoArrayOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(useNsdResolve, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(cancelHandle, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (useNsdResolve, cancelHandle, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(errnoOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(returnValueOut, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(bufferLengthOut, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (errnoOut, returnValueOut, bufferLengthOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cancelHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(useNsdResolve), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedNodeNameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedServiceNameIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedAddrInfoHintsIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addrInfoArrayOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errnoOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(returnValueOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bufferLengthOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAddrInfoRequest)

    // nn::Result GetNameInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& socketAddressPointerIn, const nn::sf::OutBuffer& hostBufferOut, const nn::sf::OutBuffer& serviceBufferOut, std::uint32_t flagsIn, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNameInfoRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(socketAddressPointerIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(hostBufferOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serviceBufferOut, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (socketAddressPointerIn, hostBufferOut, serviceBufferOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(cancelHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flagsIn, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (cancelHandle, flagsIn, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(errnoOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(returnValueOut, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (errnoOut, returnValueOut))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(cancelHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(socketAddressPointerIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hostBufferOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceBufferOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flagsIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(errnoOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(returnValueOut)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNameInfoRequest)

    // nn::Result GetCancelHandleRequest(nn::Bit64 pid, nn::sf::Out<std::uint32_t> RequestHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetCancelHandleRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(RequestHandle, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (RequestHandle))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(RequestHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetCancelHandleRequest)

    // nn::Result CancelRequest(nn::Bit64 pid, std::uint32_t RequestHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(RequestHandle, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(pid, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (RequestHandle, pid))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(RequestHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelRequest)

    // nn::Result GetHostByNameRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nameParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostByNameRequestWithOptions)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nameParam, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedHostEntryOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOptionsBuffer, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (nameParam, serializedHostEntryOut, serializedOptionsBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsRequestVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsCountIn, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (optionsRequestVersion, optionsCountIn, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSerializedHostEntrySizeOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHostError, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pSerializedHostEntrySizeOut, pOutHostError, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nameParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedHostEntryOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSerializedHostEntrySizeOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsRequestVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOptionsBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsCountIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHostError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostByNameRequestWithOptions)

    // nn::Result GetHostByAddrRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& inAddrParam, std::uint32_t inAddrLengthParam, std::int32_t addressFamilyParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetHostByAddrRequestWithOptions)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inAddrParam, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedHostEntryOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOptionsBuffer, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(3, (inAddrParam, serializedHostEntryOut, serializedOptionsBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inAddrLengthParam, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(addressFamilyParam, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsRequestVersion, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsCountIn, (::std::uint32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(5, (inAddrLengthParam, addressFamilyParam, optionsRequestVersion, optionsCountIn, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSerializedHostEntrySizeOut, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHostError, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pSerializedHostEntrySizeOut, pOutHostError, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAddrParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inAddrLengthParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(addressFamilyParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedHostEntryOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSerializedHostEntrySizeOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsRequestVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOptionsBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsCountIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHostError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetHostByAddrRequestWithOptions)

    // nn::Result GetAddrInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nodeNameParam, const nn::sf::InBuffer& serviceNameParam, const nn::sf::InBuffer& serializedHintsParam, const nn::sf::OutBuffer& serializedAddrinfoResultBuffer, nn::sf::Out<std::uint32_t> pSerializedAddrinfoResultBufferSize, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAddrInfoRequestWithOptions)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(nodeNameParam, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serviceNameParam, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedHintsParam, 2, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedAddrinfoResultBuffer, 3, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOptionsBuffer, 4, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(5, (nodeNameParam, serviceNameParam, serializedHintsParam, serializedAddrinfoResultBuffer, serializedOptionsBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsRequestVersion, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsCountIn, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (optionsRequestVersion, optionsCountIn, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pSerializedAddrinfoResultBufferSize, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pReturnCode, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHostError, (::std::int32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(4, (pSerializedAddrinfoResultBufferSize, pReturnCode, pOutHostError, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(nodeNameParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceNameParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedHintsParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedAddrinfoResultBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSerializedAddrinfoResultBufferSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pReturnCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsRequestVersion), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOptionsBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsCountIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHostError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAddrInfoRequestWithOptions)

    // nn::Result GetNameInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& socketAddressParamPointerIn, const nn::sf::OutBuffer& hostBufferOutParam, const nn::sf::OutBuffer& serviceBufferOutParam, std::uint32_t flagsParam, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t version, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetNameInfoRequestWithOptions)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(socketAddressParamPointerIn, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(hostBufferOutParam, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serviceBufferOutParam, 2, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOptionsBuffer, 3, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_AUTO_SELECT)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(4, (socketAddressParamPointerIn, hostBufferOutParam, serviceBufferOutParam, serializedOptionsBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(flagsParam, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(optionsCountIn, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (flagsParam, version, optionsCountIn, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pReturnCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutHostError, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (pReturnCode, pOutHostError, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(socketAddressParamPointerIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hostBufferOutParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serviceBufferOutParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(flagsParam), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pReturnCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOptionsBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(optionsCountIn), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutHostError), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetNameInfoRequestWithOptions)

    // nn::Result ResolverSetOptionRequest(nn::Bit64 processId, std::uint32_t version, const nn::sf::InBuffer& serializedOption, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolverSetOptionRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOption, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (serializedOption))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (version, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pReturnCode, (::std::int32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pReturnCode, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOption), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pReturnCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolverSetOptionRequest)

    // nn::Result ResolverGetOptionRequest(nn::Bit64 processId, std::uint32_t key, std::uint32_t version, const nn::sf::InBuffer& serializedOption, const nn::sf::OutBuffer& serializedOptionBufferOut, nn::sf::Out<std::uint32_t> outBufferUsed, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResolverGetOptionRequest)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOption, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(serializedOptionBufferOut, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (serializedOption, serializedOptionBufferOut))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(key, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(processId, (::nn::Bit64), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (key, version, processId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outBufferUsed, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pReturnCode, (::std::int32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutErrno, (::std::int32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(3, (outBufferUsed, pReturnCode, pOutErrno))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(processId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(key), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOption), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(serializedOptionBufferOut), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBufferUsed), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pReturnCode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutErrno)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResolverGetOptionRequest)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::socket::resolver::IResolver, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::socket::resolver::IResolver))

    // nn::Result SetDnsAddressesPrivateRequest(const nn::sf::InBuffer& sockaddrArray, std::uint32_t length) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetDnsAddressesPrivateRequest, (const ::nn::sf::InBuffer& sockaddrArray, ::std::uint32_t length))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetDnsAddressesPrivateRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(sockaddrArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(length)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetDnsAddressesPrivateRequest)
    }

    // nn::Result GetDnsAddressPrivateRequest(std::uint32_t n, const nn::sf::OutBuffer& socketAddressOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDnsAddressPrivateRequest, (::std::uint32_t n, const ::nn::sf::OutBuffer& socketAddressOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDnsAddressPrivateRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(n)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(socketAddressOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDnsAddressPrivateRequest)
    }

    // nn::Result GetHostByNameRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& name, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& name, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostByNameRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cancelHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(useNsdResolve)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(name)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hostErrorOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errnoOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedHostentResponse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferLengthOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostByNameRequest)
    }

    // nn::Result GetHostByAddrRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& serializedInAddrIn, std::uint32_t serializedInAddrLengthIn, std::uint32_t addressFamilyIn, nn::sf::Out<std::uint32_t> hostErrorOut, nn::sf::Out<std::uint32_t> errnoOut, const nn::sf::OutBuffer& serializedHostentResponse, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& serializedInAddrIn, ::std::uint32_t serializedInAddrLengthIn, ::std::uint32_t addressFamilyIn, ::nn::sf::Out<::std::uint32_t> hostErrorOut, ::nn::sf::Out<::std::uint32_t> errnoOut, const ::nn::sf::OutBuffer& serializedHostentResponse, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostByAddrRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cancelHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedInAddrIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedInAddrLengthIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addressFamilyIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hostErrorOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errnoOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedHostentResponse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferLengthOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostByAddrRequest)
    }

    // nn::Result GetHostStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostStringErrorRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errorRequestIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringErrorResponse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostStringErrorRequest)
    }

    // nn::Result GetGaiStringErrorRequest(std::uint32_t errorRequestIn, const nn::sf::OutBuffer& stringErrorResponse) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetGaiStringErrorRequest, (::std::uint32_t errorRequestIn, const ::nn::sf::OutBuffer& stringErrorResponse))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetGaiStringErrorRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errorRequestIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stringErrorResponse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetGaiStringErrorRequest)
    }

    // nn::Result GetAddrInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, bool useNsdResolve, const nn::sf::InBuffer& serializedNodeNameIn, const nn::sf::InBuffer& serializedServiceNameIn, const nn::sf::InBuffer& serializedAddrInfoHintsIn, const nn::sf::OutBuffer& addrInfoArrayOut, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut, nn::sf::Out<std::uint32_t> bufferLengthOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, bool useNsdResolve, const ::nn::sf::InBuffer& serializedNodeNameIn, const ::nn::sf::InBuffer& serializedServiceNameIn, const ::nn::sf::InBuffer& serializedAddrInfoHintsIn, const ::nn::sf::OutBuffer& addrInfoArrayOut, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut, ::nn::sf::Out<::std::uint32_t> bufferLengthOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAddrInfoRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cancelHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(useNsdResolve)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedNodeNameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedServiceNameIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedAddrInfoHintsIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addrInfoArrayOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errnoOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(returnValueOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bufferLengthOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAddrInfoRequest)
    }

    // nn::Result GetNameInfoRequest(std::uint32_t cancelHandle, nn::Bit64 pid, const nn::sf::InBuffer& socketAddressPointerIn, const nn::sf::OutBuffer& hostBufferOut, const nn::sf::OutBuffer& serviceBufferOut, std::uint32_t flagsIn, nn::sf::Out<std::uint32_t> errnoOut, nn::sf::Out<std::int32_t> returnValueOut) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequest, (::std::uint32_t cancelHandle, ::nn::Bit64 pid, const ::nn::sf::InBuffer& socketAddressPointerIn, const ::nn::sf::OutBuffer& hostBufferOut, const ::nn::sf::OutBuffer& serviceBufferOut, ::std::uint32_t flagsIn, ::nn::sf::Out<::std::uint32_t> errnoOut, ::nn::sf::Out<::std::int32_t> returnValueOut))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNameInfoRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(cancelHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(socketAddressPointerIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hostBufferOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceBufferOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flagsIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(errnoOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(returnValueOut)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNameInfoRequest)
    }

    // nn::Result GetCancelHandleRequest(nn::Bit64 pid, nn::sf::Out<std::uint32_t> RequestHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetCancelHandleRequest, (::nn::Bit64 pid, ::nn::sf::Out<::std::uint32_t> RequestHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetCancelHandleRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(RequestHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetCancelHandleRequest)
    }

    // nn::Result CancelRequest(nn::Bit64 pid, std::uint32_t RequestHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelRequest, (::nn::Bit64 pid, ::std::uint32_t RequestHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(RequestHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelRequest)
    }

    // nn::Result GetHostByNameRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nameParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByNameRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nameParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostByNameRequestWithOptions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nameParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedHostEntryOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSerializedHostEntrySizeOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsRequestVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOptionsBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsCountIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHostError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostByNameRequestWithOptions)
    }

    // nn::Result GetHostByAddrRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& inAddrParam, std::uint32_t inAddrLengthParam, std::int32_t addressFamilyParam, const nn::sf::OutBuffer& serializedHostEntryOut, nn::sf::Out<std::uint32_t> pSerializedHostEntrySizeOut, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetHostByAddrRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& inAddrParam, ::std::uint32_t inAddrLengthParam, ::std::int32_t addressFamilyParam, const ::nn::sf::OutBuffer& serializedHostEntryOut, ::nn::sf::Out<::std::uint32_t> pSerializedHostEntrySizeOut, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetHostByAddrRequestWithOptions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAddrParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inAddrLengthParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(addressFamilyParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedHostEntryOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSerializedHostEntrySizeOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsRequestVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOptionsBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsCountIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHostError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetHostByAddrRequestWithOptions)
    }

    // nn::Result GetAddrInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& nodeNameParam, const nn::sf::InBuffer& serviceNameParam, const nn::sf::InBuffer& serializedHintsParam, const nn::sf::OutBuffer& serializedAddrinfoResultBuffer, nn::sf::Out<std::uint32_t> pSerializedAddrinfoResultBufferSize, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t optionsRequestVersion, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAddrInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& nodeNameParam, const ::nn::sf::InBuffer& serviceNameParam, const ::nn::sf::InBuffer& serializedHintsParam, const ::nn::sf::OutBuffer& serializedAddrinfoResultBuffer, ::nn::sf::Out<::std::uint32_t> pSerializedAddrinfoResultBufferSize, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t optionsRequestVersion, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAddrInfoRequestWithOptions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(nodeNameParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceNameParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedHintsParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedAddrinfoResultBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSerializedAddrinfoResultBufferSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pReturnCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsRequestVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOptionsBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsCountIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHostError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAddrInfoRequestWithOptions)
    }

    // nn::Result GetNameInfoRequestWithOptions(nn::Bit64 processId, const nn::sf::InBuffer& socketAddressParamPointerIn, const nn::sf::OutBuffer& hostBufferOutParam, const nn::sf::OutBuffer& serviceBufferOutParam, std::uint32_t flagsParam, nn::sf::Out<std::int32_t> pReturnCode, std::uint32_t version, const nn::sf::InBuffer& serializedOptionsBuffer, std::uint32_t optionsCountIn, nn::sf::Out<std::int32_t> pOutHostError, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetNameInfoRequestWithOptions, (::nn::Bit64 processId, const ::nn::sf::InBuffer& socketAddressParamPointerIn, const ::nn::sf::OutBuffer& hostBufferOutParam, const ::nn::sf::OutBuffer& serviceBufferOutParam, ::std::uint32_t flagsParam, ::nn::sf::Out<::std::int32_t> pReturnCode, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOptionsBuffer, ::std::uint32_t optionsCountIn, ::nn::sf::Out<::std::int32_t> pOutHostError, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetNameInfoRequestWithOptions)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(socketAddressParamPointerIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hostBufferOutParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serviceBufferOutParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(flagsParam)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pReturnCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOptionsBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(optionsCountIn)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutHostError)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetNameInfoRequestWithOptions)
    }

    // nn::Result ResolverSetOptionRequest(nn::Bit64 processId, std::uint32_t version, const nn::sf::InBuffer& serializedOption, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolverSetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolverSetOptionRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pReturnCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolverSetOptionRequest)
    }

    // nn::Result ResolverGetOptionRequest(nn::Bit64 processId, std::uint32_t key, std::uint32_t version, const nn::sf::InBuffer& serializedOption, const nn::sf::OutBuffer& serializedOptionBufferOut, nn::sf::Out<std::uint32_t> outBufferUsed, nn::sf::Out<std::int32_t> pReturnCode, nn::sf::Out<std::int32_t> pOutErrno) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResolverGetOptionRequest, (::nn::Bit64 processId, ::std::uint32_t key, ::std::uint32_t version, const ::nn::sf::InBuffer& serializedOption, const ::nn::sf::OutBuffer& serializedOptionBufferOut, ::nn::sf::Out<::std::uint32_t> outBufferUsed, ::nn::sf::Out<::std::int32_t> pReturnCode, ::nn::sf::Out<::std::int32_t> pOutErrno))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResolverGetOptionRequest)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(processId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(key)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOption)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(serializedOptionBufferOut)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBufferUsed)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pReturnCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutErrno)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResolverGetOptionRequest)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::socket::resolver::IResolver>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::socket::resolver::IResolver))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetDnsAddressesPrivateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(sockaddrArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetDnsAddressesPrivateRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(sockaddrArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(length)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDnsAddressPrivateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(socketAddressOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDnsAddressPrivateRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(n),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(socketAddressOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostByNameRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(name)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedHostentResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostByNameRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(cancelHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(useNsdResolve),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(name),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hostErrorOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(errnoOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedHostentResponse),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bufferLengthOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostByAddrRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedInAddrIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedHostentResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostByAddrRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(cancelHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedInAddrIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(serializedInAddrLengthIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addressFamilyIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(hostErrorOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(errnoOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedHostentResponse),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bufferLengthOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostStringErrorRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringErrorResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostStringErrorRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(errorRequestIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringErrorResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetGaiStringErrorRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(stringErrorResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetGaiStringErrorRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(errorRequestIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(stringErrorResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAddrInfoRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedNodeNameIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedServiceNameIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedAddrInfoHintsIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(addrInfoArrayOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAddrInfoRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(cancelHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(useNsdResolve),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedNodeNameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedServiceNameIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedAddrInfoHintsIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(addrInfoArrayOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(errnoOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(returnValueOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(bufferLengthOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNameInfoRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(socketAddressPointerIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(hostBufferOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serviceBufferOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNameInfoRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(cancelHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(socketAddressPointerIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(hostBufferOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serviceBufferOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flagsIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(errnoOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(returnValueOut)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetCancelHandleRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetCancelHandleRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(RequestHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(pid)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(pid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(RequestHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostByNameRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nameParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedHostEntryOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOptionsBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostByNameRequestWithOptions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nameParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedHostEntryOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSerializedHostEntrySizeOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsRequestVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOptionsBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsCountIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHostError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetHostByAddrRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inAddrParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedHostEntryOut)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOptionsBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetHostByAddrRequestWithOptions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inAddrParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inAddrLengthParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(addressFamilyParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedHostEntryOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSerializedHostEntrySizeOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsRequestVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOptionsBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsCountIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHostError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAddrInfoRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(nodeNameParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serviceNameParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedHintsParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedAddrinfoResultBuffer)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOptionsBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAddrInfoRequestWithOptions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(nodeNameParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serviceNameParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedHintsParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedAddrinfoResultBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pSerializedAddrinfoResultBufferSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pReturnCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsRequestVersion),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOptionsBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsCountIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHostError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetNameInfoRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(socketAddressParamPointerIn)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(hostBufferOutParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serviceBufferOutParam)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOptionsBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetNameInfoRequestWithOptions)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(socketAddressParamPointerIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(hostBufferOutParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serviceBufferOutParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(flagsParam),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pReturnCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOptionsBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(optionsCountIn),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutHostError),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolverSetOptionRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOption)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolverSetOptionRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOption),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pReturnCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResolverGetOptionRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOption)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(serializedOptionBufferOut)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(processId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResolverGetOptionRequest)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(processId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(key),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOption),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(serializedOptionBufferOut),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outBufferUsed),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pReturnCode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutErrno)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetDnsAddressesPrivateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDnsAddressPrivateRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostByNameRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostByAddrRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostStringErrorRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetGaiStringErrorRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAddrInfoRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNameInfoRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetCancelHandleRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostByNameRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetHostByAddrRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAddrInfoRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetNameInfoRequestWithOptions)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolverSetOptionRequest)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResolverGetOptionRequest)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::socket::resolver::IResolver))
