﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/socket/socket_Types.h>
#include <nn/socket/socket_ResolverOptionsPrivate.h>

namespace nn { namespace socket { namespace resolver {

/**
 * @brief separate symbols are provided for DFC and HIPC
 *        but you can also use a single symbol and branched implementation.
 */
Result InitializeResolverByHipc() NN_NOEXCEPT;

/**
 * @brief destructor function for TLS
 * @param value the value to destroy
 */
void TlsDestructFunction(uintptr_t value);

/**
 * @brief Setup the internal resolver cancel's resources.
 */
Result   Initialize() NN_NOEXCEPT;

/**
 * @brief Finalize any resolver specific resources .
 */
Result   Finalize() NN_NOEXCEPT;

/**
 * @brief Cancel all resolver transaction associated with this pid.
 * @param pid - the pid of the calling function.
 */
void    CancelAll(Bit64 pid) NN_NOEXCEPT;

}}}
