﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/socket/socket_Types.h>
#include <nn/socket/private/sys/socket_Iovec.h>

namespace nn {
namespace socket {

/**
    Structure used for @ref SendMsg() and @ref RecvMsg().
*/
struct MsgHdr
{
    void*       msg_name;       ///< Optional address.
    SockLenT    msg_namelen;    ///< Size of address.
    Iovec*      msg_iov;        ///< Scatter/gather array.
    int         msg_iovlen;     ///< # elements in msg_iov.
    void*       msg_control;    ///< Ancillary data.
    SockLenT    msg_controllen; ///< Ancillary data buffer len.
    MsgFlag     msg_flags;      ///< Flags on received message.
};

/**
    Structure used for @ref SendMMsg() and @ref RecvMMsg()
*/
struct MMsgHdr
{
    MsgHdr      msg_hdr;    ///<
    SockLenT    msg_len;    ///<
};

/**
    Header for ancillary data objects in msg_control buffer.
    Used for additional information with/about a datagram
    not expressible by flags.  The format is a sequence
    of message elements headed by CMsgHdr structures.
*/
struct CMsgHdr
{
    SockLenT    cmsg_len;       ///< Data byte count, including header.
    Level       cmsg_level;     ///< Originating protocol.
    int         cmsg_type;      ///< Protocol-specific type
/* followed by u_char cmsg_data[]; */
};

#if 0
/* given pointer to struct cmsghdr, return pointer to data */
#define CMSG_DATA(cmsg) \
    ((unsigned char *)(cmsg) + _ALIGN(sizeof(CMsgHdr)))

/* given pointer to struct cmsghdr, return pointer to next cmsghdr */
#define CMSG_NXTHDR(mhdr, cmsg)    \
    ((char *)(cmsg) == NULL ? CMSG_FIRSTHDR(mhdr) : \
        ((char *)(cmsg) + _ALIGN(((CMsgHdr *)(cmsg))->cmsg_len) + \
        _ALIGN(sizeof(CMsgHdr)) > \
        (char *)(mhdr)->msg_control + (mhdr)->msg_controllen) ? \
        (CMsgHdr *)0 : \
        (CMsgHdr *)(void *)((char *)(cmsg) + \
        _ALIGN(((CMsgHdr *)(cmsg))->cmsg_len)))

/*
 * RFC 2292 requires to check msg_controllen, in case that the kernel returns
 * an empty list for some reasons.
 */
#define CMSG_FIRSTHDR(mhdr) \
    ((mhdr)->msg_controllen >= sizeof(CMsgHdr) ? \
     (CMsgHdr *)(mhdr)->msg_control : \
     (CMsgHdr *)nullptr)

/* RFC 2292 additions */
#define CMSG_SPACE(l)       (_ALIGN(sizeof(CMsgHdr)) + _ALIGN(l))
#define CMSG_LEN(l)         (_ALIGN(sizeof(CMsgHdr)) + (l))
#endif

}} /* nn::socket */
