﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <cstring>

namespace nn {
namespace sm {

    struct ServiceName
    {
        static const int Length = 8;
        static const ServiceName InvalidName;

        char value[Length];

        static ServiceName Make(const char* pName, size_t size)
        {
            ServiceName name;

            for( size_t i = 0; i < sizeof(value); ++i )
            {
                name.value[i] = (i < size) ? pName[i]: '\0';
            }

            return name;
        }
    };

    inline bool operator ==(const ServiceName& a, const ServiceName& b)
    {
        return std::memcmp(&a, &b, sizeof(a)) == 0;
    }
    inline bool operator !=(const ServiceName& a, const ServiceName& b)
    {
        return ! (a == b);
    }


} // end of namespace sm
} // end of namespace nn
