﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>
#include <nn/sf/hipc/sf_HipcTlsBuffer.h>

#include <nn/TargetConfigs/build_Os.h>
#if defined(NN_BUILD_CONFIG_OS_WIN32)
    #include <nn/sf/hipc/sf_HipcDirectApi-os.win32.h>
#endif

namespace nn { namespace sf { namespace hipc {

Result CreatePort(HipcServerPortHandle* pOutServer, HipcClientPortHandle* pOutClient, int maxSessions) NN_NOEXCEPT;
void CloseServerPortHandle(HipcServerPortHandle handle) NN_NOEXCEPT;
void CloseClientPortHandle(HipcClientPortHandle handle) NN_NOEXCEPT;

void AttachWaitHolderForAccept(nn::os::MultiWaitHolderType* pHolder, HipcServerPortHandle port) NN_NOEXCEPT;
Result AcceptSession(HipcServerSessionHandle* pOut, HipcServerPortHandle port) NN_NOEXCEPT;
void AttachWaitHolderForConnect(nn::os::MultiWaitHolderType* pHolder, HipcClientPortHandle port) NN_NOEXCEPT;
Result ConnectToPort(HipcClientSessionHandle* pOut, HipcClientPortHandle port, bool blocking) NN_NOEXCEPT;
Result CreateSession(HipcServerSessionHandle* pOutServer, HipcClientSessionHandle* pOutClient) NN_NOEXCEPT;
void CloseServerSessionHandle(HipcServerSessionHandle handle) NN_NOEXCEPT;
void CloseClientSessionHandle(HipcClientSessionHandle handle) NN_NOEXCEPT;

enum class ReceiveResult
{
    Process,
    Close,
    Retry,
};

void AttachWaitHolderForReceive(nn::os::MultiWaitHolderType* pHolder, HipcServerSessionHandle session) NN_NOEXCEPT;
Result Receive(bool* pClosed, HipcServerSessionHandle session, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT; // ビルド互換性維持用
Result Receive(ReceiveResult* pReceiveResult, HipcServerSessionHandle session, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT;
Result Reply(HipcServerSessionHandle session, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT;

Result SendSyncRequest(HipcClientSessionHandle session, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT;

Result SendAsyncRequest(HipcClientRequestHandle* pOut, HipcClientSessionHandle session, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT;
void AttachWaitHolderForReply(nn::os::MultiWaitHolderType* pHolder, HipcClientRequestHandle request) NN_NOEXCEPT;
Result WaitClientRequestHandle(HipcClientRequestHandle request, void* messageBuffer, size_t messageBufferSize) NN_NOEXCEPT;
void CloseClientRequestHandle(HipcClientRequestHandle request) NN_NOEXCEPT;

}}}
