﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/os/os_NativeHandle.h>
#include <nn/sf/hipc/sf_HipcHandleTypes.h>

namespace nn { namespace sf { namespace hipc { namespace detail {

#if defined(NN_BUILD_CONFIG_OS_WIN32)
struct InternalHandleValue
{
    nn::Bit32 value;

    bool operator==(const InternalHandleValue& o)
    {
        return value == o.value;
    }
    bool operator!=(const InternalHandleValue& o)
    {
        return !(*this == o);
    }
};
const InternalHandleValue InvalidInternalHandleValue = {0};
typedef uint64_t InternalAddressValue;
#elif defined(NN_BUILD_CONFIG_OS_HORIZON)
typedef os::NativeHandle InternalHandleValue;
static_assert(sizeof(InternalHandleValue) == sizeof(nn::Bit32), "[SF-Internal] sizeof(InternalHandleValue)");
const InternalHandleValue InvalidInternalHandleValue = os::InvalidNativeHandle;
typedef uintptr_t InternalAddressValue;
#else
#error   "未サポートの OS 種別が指定されています。"
#endif

InternalHandleValue RegisterSessionHandle(HipcClientSessionHandle handle) NN_NOEXCEPT;
InternalHandleValue RegisterOsHandle(os::NativeHandle handle) NN_NOEXCEPT;
HipcClientSessionHandle UnregisterSessionHandle(InternalHandleValue key) NN_NOEXCEPT;
os::NativeHandle UnregisterOsHandle(InternalHandleValue key) NN_NOEXCEPT;

InternalAddressValue RegisterAddress(uintptr_t address) NN_NOEXCEPT;
uintptr_t UnregisterAddress(InternalAddressValue value) NN_NOEXCEPT;

#if defined(NN_BUILD_CONFIG_OS_HORIZON)

inline InternalHandleValue RegisterSessionHandle(HipcClientSessionHandle handle) NN_NOEXCEPT
{
    static_assert(sizeof(handle) == sizeof(InternalHandleValue), "[SF-Internal] sizeof(HipcClientSessionHandle)");
    InternalHandleValue key;
    std::memcpy(&key, &handle, sizeof(key));
    return key;
}
inline HipcClientSessionHandle UnregisterSessionHandle(InternalHandleValue key) NN_NOEXCEPT
{
    HipcClientSessionHandle handle;
    std::memcpy(&handle, &key, sizeof(handle));
    return handle;
}
inline InternalHandleValue RegisterOsHandle(os::NativeHandle handle) NN_NOEXCEPT
{
    return handle;
}
inline os::NativeHandle UnregisterOsHandle(InternalHandleValue key) NN_NOEXCEPT
{
    return key;
}

inline InternalAddressValue RegisterAddress(uintptr_t address) NN_NOEXCEPT
{
    return address;
}

inline uintptr_t UnregisterAddress(InternalAddressValue value) NN_NOEXCEPT
{
    return value;
}

#endif

}}}}
