﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/cmif/sf_CmifDomainCommon.h>
#include <nn/sf/cmif/server/sf_CmifServerObjectInfo.h>

namespace nn { namespace sf { namespace cmif { namespace server {

// サーバ側における ICmifDomain のインターフェイス
class CmifServerDomain
{
public:
    virtual Result ReserveEntry(CmifDomainObjectId ids[], int count) NN_NOEXCEPT = 0;
    virtual void UnReserveEntry(const CmifDomainObjectId ids[], int count) NN_NOEXCEPT = 0;
    virtual void RegisterObject(CmifDomainObjectId id, CmifServerObjectInfo&& x) NN_NOEXCEPT = 0;
    virtual CmifServerObjectInfo UnregisterObject(CmifDomainObjectId id) NN_NOEXCEPT = 0;
    virtual CmifServerObjectInfo GetObject(CmifDomainObjectId id) NN_NOEXCEPT = 0;
protected:
    ~CmifServerDomain() {}
};

}}}}
