﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/server/sf_CmifServerMessage.h>

namespace nn { namespace sf { namespace cmif { namespace server { namespace detail {

    struct CmifProcessFunctionTable
    {
        nn::Result (*processServerMessage)(IServiceObject* p, CmifServerMessage* message, const PointerAndSize& rawData) NN_NOEXCEPT;
    };

    // Interface に対応する CmifProcessFunctionTable を取得するための構造体テンプレート。
    // (Tag 引数は、ヘッダ中で s_Table の実体を作成するためのダミー引数)
    // 自動生成系が、このテンプレートを Interface に対して特殊化するコードを生成することで、
    // CmifProcessFunctionTableGetter<Interface>::s_Table で、Interface に対する処理関数テーブルを取得できる。
    template <typename Interface, typename Tag = void>
    struct CmifProcessFunctionTableGetter;
    #if 0
    template <typename Tag>
    struct CmifProcessFunctionTableGetter<MyInterface, Tag>
    {
        static const CmifProcessFunctionTable s_Table;
    };

    template <typename Tag>
    const CmifProcessFunctionTable CmifProcessFunctionTableGetter<MyInterface, Tag>::s_Table =
    {
        ...
    };
    #endif

}}}}}
