﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/TargetConfigs/build_Cpu.h>
#include <nn/nn_Common.h>
#include <nn/nn_BitTypes.h>

namespace nn { namespace ro {
namespace detail {
namespace Elf {
namespace Elf64 {
typedef uint64_t Addr;
typedef uint16_t Half;
typedef uint64_t Off;
typedef int32_t  Sword;
typedef uint32_t Word;
typedef int64_t  Sxword;
typedef uint64_t Xword;

class Sym
{
private:
    Word            m_Name;
    unsigned char   m_Info;
    unsigned char   m_Other;
    Half            m_Shndx;
    Addr            m_Value;
    Xword           m_Size;
public:
    Addr GetValue() const
    {
        return m_Value;
    }
    Word GetName() const
    {
        return m_Name;
    }
    unsigned char GetType() const
    {
        return m_Info & 0xF;
    }
    unsigned char GetBind() const
    {
        return m_Info >> 4;
    }
    unsigned char GetOther() const
    {
        return m_Other;
    }
    unsigned char GetVisibility() const
    {
        return GetOther() & 0x3;
    }
    Half GetShndx() const
    {
        return m_Shndx;
    }
    Xword GetSize() const
    {
        return m_Size;
    }
};

class Rel
{
private:
    Addr    m_Offset;
    Xword   m_Info;
public:
    Xword   GetSym() const
    {
        return m_Info >> 32;
    }
    Xword   GetType() const
    {
        return m_Info & 0xFFFFFFFF;
    }
    Addr    GetOffset() const
    {
        return m_Offset;
    }
};

class Rela
{
private:
    Addr    m_Offset;
    Xword   m_Info;
    Sxword  m_Addend;
public:
    Xword   GetSym() const
    {
        return m_Info >> 32;
    }
    Xword   GetType() const
    {
        return m_Info & 0xFFFFFFFF;
    }
    Addr    GetOffset() const
    {
        return m_Offset;
    }
    Sxword  GetAddend() const
    {
        return m_Addend;
    }
};


class Dyn
{
private:
    Sxword  m_Tag;
    union
    {
        Xword val;
        Addr ptr;
    } m_Un;
public:
    Sxword GetTag() const
    {
        return m_Tag;
    }
    Addr GetPtr() const
    {
        return m_Un.ptr;
    }
    Xword GetVal() const
    {
        return m_Un.val;
    }
};

#if defined NN_BUILD_CONFIG_CPU_ARM64
namespace aarch64 {
enum RelocationCode
{
    R_NONE          = 256,
    R_ABS64         = 257,
    R_ABS32         = 258,
    R_COPY          = 1024,
    R_GLOB_DAT      = 1025,
    R_JUMP_SLOT     = 1026,
    R_RELATIVE      = 1027,
    R_TLS_DTPREL64  = 1028,
    R_TLS_DTPMOD64  = 1029,
    R_TLS_TPREL64   = 1030,
    R_TLS_DTPREL32  = 1031,
    R_TLS_DTPMOD32  = 1032,
    R_TLS_TPREL32   = 1033
};
}
using namespace nn::ro::detail::Elf::Elf64::aarch64;
#endif
}
}
}
}}
