﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn {
namespace pinmux {

/**
* @brief 検査向けに変更可能なピングループの名前
*
* @details NX spec の Pinmux ライブラリで検査向けに変更可能なピングループの定義です。
*/
enum AssignablePinGroupNameForHardwareTest
{
    AssignablePinGroupNameForHardwareTest_UartD = 100, //!< UartD
};

/**
* @brief 検査向けにピンアサインできる機能
*
* @details NX spec の Pinmux ライブラリで検査向けにピンアサイン可能な定義です。
*/
enum PinAssignmentForHardwareTest
{
    PinAssignmentForHardwareTest_UartDHiZ            = 100, //!< AssignablePinGroupNameForHardwareTest_UartD に対して指定可能
    PinAssignmentForHardwareTest_UartDEnable         = 101, //!< AssignablePinGroupNameForHardwareTest_UartD に対して指定可能
};

} //gpio
} //nn
