﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/account/account_Types.h>

namespace nn { namespace ovln { namespace format {

//! @brief フレンドリストのサマリー情報（オンラインフレンド人数＋フレンド申請件数）を通知するメッセージです。
const uint32_t ListSummaryTag = 7001;
//! @brief フレンドがオンラインになったことを通知するメッセージです。
const uint32_t FriendOnlineTag = 7002;
//! @brief フレンド申請受信を通知するメッセージです。
const uint32_t FriendRequestReceivedTag = 7003;

//! @brief フレンドリストのサマリー情報を通知するメッセージの型です。
struct ListSummary
{
    //! @brief ユーザーアカウントです。
    nn::account::Uid uid;

    //! @brief オンラインフレンド人数です。
    int32_t onlineFriendCount;

    //! @brief 未読のフレンド申請件数です。
    int32_t unreadFriendRequestCount;

    //! @brief 既読のフレンド申請件数です。
    int32_t readFriendRequestCount;
};

//! @brief フレンドがオンラインになったことを通知するメッセージの型です。
struct FriendOnline
{
    //! @brief ユーザーアカウントです。
    nn::account::Uid uid;

    //! @brief フレンドのネットワークサービスアカウント ID です。
    nn::account::NetworkServiceAccountId friendAccountId;

    //! @brief 前回のフレンドプレゼンス更新時刻からの経過時間（秒）です。
    int32_t elapsedSecondsFromLastUpdate;
};

//! @brief フレンド申請を受信したことを通知するメッセージの型です。
struct FriendRequestReceived
{
    //! @brief ユーザーアカウントです。
    nn::account::Uid uid;
};

}}}
