﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ncm/ncm_ContentMetaId.h>

namespace nn { namespace ovln { namespace format {

const uint32_t DownloadCompleteLegacyDataTag = 5000; // 3.0NUP まではこちらのタグで送っている
const uint32_t DownloadCompleteDataTag = 5001;       // 4.0NUP 以降、こちらのタグで送る

const uint32_t ContentAvailableDataTag = 5002;

struct DownloadCompleteLegacyData
{
    ncm::ApplicationId applicationId;
};

enum class DownloadedDataType : Bit32
{
    Application  = 1u << 0,
    Patch        = 1u << 1,
    AddOnContent = 1u << 2,
    Unknown      = 1u << 31
};

enum class DownloadedApplicationAttributes : Bit8
{
    Prepurchase = 1u << 0,  // アプリケーションが予約購入状態である属性、別の手段で権利の確認を行うのでオーバーレイ通知が利用する想定はない
};

struct DownloadCompleteData
{
    ncm::ApplicationId applicationId;
    Bit32              downloadedDataTypes;             // DownloadedDatType の BitFlag
    Bit8               downloadedApplicationAttributes; // DownloadApplicationAttributes の BitFlag
    Bit8               reserved[11];
};

NN_STATIC_ASSERT(std::is_pod<DownloadCompleteData>::value);

enum class AvailableDataType : Bit32
{
    Application  = 1u << 0,
    Patch        = 1u << 1,
    AddOnContent = 1u << 2,
    Unknown      = 1u << 31
};

struct ContentAvailableData
{
    ncm::ApplicationId applicationId;
    Bit32              availableDataType; // AvailableDataType の BitFlag
    Bit8               reserved[12];
};

NN_STATIC_ASSERT(std::is_pod<ContentAvailableData>::value);

}}}
